<?php
class tapatalk_Api_Node extends vB_Api_Extensions
{
    public $product = 'tapatalk';   //productid
    public $version = '1.3.0';      //tapatalk version
    public $title = 'Tapatalk';
    public $minver = '5.1.0';       //min sys version that can use this hook

    public $AutoInstall = 0;        // 1 will check and update automatically while 0 not
    public $extensionOrder = 5;

    public $options;

    public function callNamed()
    {
        list($current, $method, $args) = func_get_args();
        try{
            $dopush = 0;
            $hard = 0;
            $spamuids = "";
            if($method == "deleteNodes")
            {
                $dopush = 1;
                $nodeids = $args['nodeids'];
                $hard = $args['hard'];
            }
            elseif($method == "deleteNodesAsSpam")
            {
                $dopush = 1;
                $hard = $args['hard'];
                $nodeids = $args['nodeids'];
                if(!empty($args['userids']) && is_array($args['userids']))
                    $spamuids = implode(",", $args['userids']);

            }
            elseif($method == "manageDeletedNode")
            {
                $dopush = 1;
                $manageDtype = $args['params']['deletetype'];
                $hard = 1;
                if($manageDtype == "3")
                {
                    $nodeid = $args['nodeid'];
                    $nodeids = array($nodeid);
                }
            }

            if($dopush && !empty($nodeids))
            {
                $deletedType = '';
                if($hard){
                    /*
                      We can get thread type when do soft-delete, or do hard delete by manage after soft-delete.
                      But if user do hard delete directly, we cannot get the thread type. So here just not send
                      delete push if user hard-delete thread directly because we cannot know the thread is topic or post.
                     */
                    if(isset($args['params']['topictitle']))
                        $deletedType = empty($args['params']['topictitle']) ? "delpost" : "deltopic";
                }else{
                    $egnodeid = $nodeids[0];
                    $egNode = vB_Library::instance('node')->getNode($egnodeid);
                    $parentNode = vB_Library::instance('node')->getNode($egNode['parentid']);
                    $contenttypeid = $parentNode['contenttypeid'];
                    $topChannels = vB_Api::instanceInternal('content_channel')->fetchTopLevelChannelIds();
 			        $forumparentid = $topChannels['forum'];

                    //judge if topic or post
                    $isTopicOrPost = false;
                    $loopParentId =  $parentNode['parentid'];
                    while(!empty($loopParentId))
                    {
                        if($loopParentId == $forumparentid){
                            $isTopicOrPost = true;
                            break;
                        }
                        $loopParentNode = vB_Library::instance('node')->getNode($loopParentId);
                        $loopParentId = $loopParentNode['parentid'];
                    }
                    $topicType = vB_Types::instance()->getContentTypeID('vBForum_Channel');
                    $postType = vB_Types::instance()->getContentTypeID('vBForum_Text');

                    if($isTopicOrPost && $contenttypeid == $topicType)
                    {
                        $deletedType = 'deltopic';
                    }
                    elseif($isTopicOrPost && $contenttypeid == $postType)
                    {
                        $deletedType = 'delpost';
                    }
                }

                if($deletedType)
                {
                    if(!defined('IN_MOBIQUO')){
                        $vboptions = vB::get_datastore()->get_value('options');
                        $tt_dir = $vboptions['tapatalk_directory'];
                        define('MBQ_DS_TT', DIRECTORY_SEPARATOR);
                        define('MBQ_PATH', ".".MBQ_DS_TT."{$tt_dir}".MBQ_DS_TT);
                        require_once(MBQ_PATH."mobiquoCommon.php");
                        include_once(MBQ_PATH."push".MBQ_DS_TT."TapatalkPush.php");
                    }
                    $oTapatalkPush = new TapatalkPush();
                    $push_data['id'] = implode(",", $nodeids);
                    $push_data['type'] = $deletedType;
                    // $push_data['hard'] = $hard;
                    $push_data['spamuids'] = $spamuids;

                    $oTapatalkPush->doPushDelete($push_data);
                }
            }

        } catch (Exception $e) {
            error_log("Caught Tapatalk Push Error $e");
        }

        return parent::callNamed($current, $method, $args);
    }
}
