<?php
class tapatalk_Api_Content_Privatemessage extends vB_Api_Extensions
{
    public $product = 'tapatalk';   //productid
    public $version = '1.3.6';      //tapatalk version
    public $title = 'Tapatalk';
    public $minver = '5.1.0';       //min sys version that can use this hook

    public $AutoInstall = 0;        // 1 will check and update automatically while 0 not
    public $extensionOrder = 5;

    public $options;

    /**
     *
     * @param  int  $getval  this is the value returned form function 'add($data, $options = array())' in privatemessage.php
     * The other params are just the same to the hook-from function
     *
     */
    public function add($getval, $data, $options = array())
    {
        if(!$getval || $getval <= 9 )
            return $getval;

        try{
            $currentuid = 0;
            if(!$data['respondto'])
            {
                $node = vB_Library::instance('node')->getNode($getval);
                $push_data['id'] = $getval;
                $push_data['mid'] = $getval;
                $push_data['title'] = $data['title'];
                $push_data['content'] = $data['rawtext'];
                $push_data['dateline'] = $node['created'];
                $currentuid = $node['userid'];
            } elseif($data['respondto']){
                $respondToNode = vB_Library::instance('node')->getNode($data['respondto']);
                $push_data['id'] = $respondToNode['nodeid'];
                $push_data['title'] = $respondToNode['title'];
                $push_data['dateline'] = $respondToNode['lastcontent'];
                $push_data['mid'] = $getval;
                $push_data['content'] = $data['rawtext'];
                $currentuid = $respondToNode['userid'];
            }

            $db = vB::getDBAssertor()->getDBConnection();
            $res = $db->query_first(" SELECT DISTINCT userid FROM " . TABLE_PREFIX . "sentto where nodeid=$getval and userid != $currentuid" );
            $push_data['userid'] = $res['userid'];
            if(!defined('IN_MOBIQUO')){
                $vboptions = vB::get_datastore()->get_value('options');
                $tt_dir = $vboptions['tapatalk_directory'];
                define('MBQ_DS_TT', DIRECTORY_SEPARATOR);
                define('MBQ_PATH', ".".MBQ_DS_TT."{$tt_dir}".MBQ_DS_TT);
                require_once(MBQ_PATH."mobiquoCommon.php");
                include_once(MBQ_PATH."push".MBQ_DS_TT."TapatalkPush.php");
            }
            $oTapatalkPush = new TapatalkPush();
            $oTapatalkPush->doPushNewConversation($push_data);
        } catch (Exception $e) {
            error_log("Caught Tapatalk Push Error $e");
        }

        return $getval;
    }
}
