<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseRdForumSearch');

/**
 * forum search class
 */
Class MbqRdForumSearch extends MbqBaseRdForumSearch {

    public function __construct() {
    }

    /**
     * forum advanced search
     *
     * @param  Array  $filter  search filter
     * @param  Object  $oMbqDataPage
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'advanced' means advanced search
     * @return  Object  $oMbqDataPage
     */
    public function forumAdvancedSearch($filter, $oMbqDataPage, $mbqOpt) {
        if ($mbqOpt['case'] == 'getLatestTopic' || $mbqOpt['case'] == 'getUnreadTopic' || $mbqOpt['case'] == 'getParticipatedTopic') {
            $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
            if ($mbqOpt['case'] == 'getParticipatedTopic') {
                $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
                $search['channel'] = $top['forum'];
            	$search['authorid'] = ($filter['userid'])? $filter['userid'] : MbqMain::$oCurMbqEtUser->userId->oriValue;
            	$search['view'] = vB_Api_Search::FILTER_VIEW_TOPIC;
                $search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
            	$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
                $search['sort']['publishdate'] = 'desc';
            	$search['exclude'] = MbqMain::$oMbqAppEnv->hideForumIds;
                try {
                    $result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                    if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                        $oMbqDataPage->totalNum = $result['totalRecords'];
                        $nodeIds = $result['nodeIds'];
                    } else {
                        $oMbqDataPage->totalNum = 0;
                        $nodeIds = array();
                    }
                }
                catch (Exception $e) {
                    $oMbqDataPage->totalNum = 0;
                    $nodeIds = array();
                }
                /* common begin */
                $mbqOpt['case'] = 'byTopicIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                return $oMbqRdEtForumTopic->getObjsMbqEtForumTopic($nodeIds, $mbqOpt);
                /* common end */
            } elseif ($mbqOpt['case'] == 'getLatestTopic' || $mbqOpt['case'] == 'getUnreadTopic') {
                $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
                $search['channel'] = $top['forum'];
                $search['view'] = vB_Api_Search::FILTER_VIEW_TOPIC;
                $search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
                $search['sort']['lastcontent'] = 'desc';
                $search['exclude'] = MbqMain::$oMbqAppEnv->hideForumIds;
                if(!empty($mbqOpt['unread'])) $search['unread_only'] = true;
                try {
                    $result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                    if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                        $oMbqDataPage->totalNum = $result['totalRecords'];
                        $arrTopicRecord = $result['results'];
                    } else {
                        $oMbqDataPage->totalNum = 0;
                        $arrTopicRecord = array();
                    }

                }
                catch (Exception $e) {
                    $oMbqDataPage->totalNum = 0;
                    $arrTopicRecord = array();
                }
                /* common begin */
                $nodeIds = array();
                foreach ($arrTopicRecord as $topicRecord) {
                    $nodeIds[] = $topicRecord['nodeid'];
                }
                $mbqOpt['case'] = 'byTopicIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                return $oMbqRdEtForumTopic->getObjsMbqEtForumTopic($nodeIds, $mbqOpt);
                /* common end */
            }
        } elseif ($mbqOpt['case'] == 'searchTopic') {
            $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
            $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
            $search['channel'] = $top['forum'];
        	$search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
        	$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
            $search['sort']['lastcontent'] = 'desc';
            $search['keywords'] = $filter['keywords'];
            $search['exclude'] = MbqMain::$oMbqAppEnv->hideForumIds;
            $search['view'] = 'topic';
            try {
                $result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    $nodeIds = array();
                    $oMbqDataPage->totalNum = $result['totalRecords'];
                    $arrRecord = $result['results'];
                    foreach ($arrRecord as $postRecord) {
                        $nodeIds[] = $postRecord['nodeid'];
                    }
                } else {
                    $oMbqDataPage->totalNum = 0;
                    $nodeIds = array();
                }
            }
            catch (Exception $e) {
                $oMbqDataPage->totalNum = 0;
                $nodeIds = array();
            }
            $mbqOpt['case'] = 'byTopicIds';
            $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
            $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
            return $oMbqRdEtForumTopic->getObjsMbqEtForumTopic($nodeIds, $mbqOpt);

        } elseif ($mbqOpt['case'] == 'searchPost') {
            $oMbqRdEtForumPost = MbqMain::$oClk->newObj('MbqRdEtForumPost');
            $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
            $search['channel'] = $top['forum'];
        	$search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
        	$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
            $search['sort']['lastcontent'] = 'desc';
            $search['keywords'] = $filter['keywords'];
            $search['exclude'] = MbqMain::$oMbqAppEnv->hideForumIds;
        	try {
                $result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    $nodeIds = array();
                    $oMbqDataPage->totalNum = $result['totalRecords'];
                    $arrRecord = $result['results'];
                    foreach ($arrRecord as $postRecord) {
                        $nodeIds[] = $postRecord['nodeid'];
                    }
                } else {
                    $oMbqDataPage->totalNum = 0;
                    $nodeIds = array();
                }
            }
            catch (Exception $e) {
                $oMbqDataPage->totalNum = 0;
                $nodeIds = array();
            }
            $oMbqRdEtForumPost = MbqMain::$oClk->newObj('MbqRdEtForumPost');
            $mbqOpt['case'] = 'byPostIds';
            $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
            return $oMbqRdEtForumPost->getObjsMbqEtForumPost($nodeIds, $mbqOpt);

        } elseif ($mbqOpt['case'] == 'advanced') {
            MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_NOT_ACHIEVE);
        }
        elseif ($mbqOpt['case'] == 'search') {

            $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
            $search['channel'] = $top['forum'];
        	$search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
        	$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
            $search['sort']['lastcontent'] = 'desc';
            $search['exclude'] = MbqMain::$oMbqAppEnv->hideForumIds;
            if(!$filter->showPosts)
            {
                $search['view'] = 'topic';
            }
            if($filter->startedBy)
            {
                $search['author'] = $filter->searchUser;
                $search['starter_only'] = $filter->searchUser;
            }
            if($filter->titleOnly)
            {
                $search['title_only'] = true;
            }
            if($filter->searchUser)
            {
                $search['author'] = $filter->searchUser;
            }
            if($filter->userId)
            {
                $search['authorid'] = $filter->userId;
            }
            if($filter->forumId)
            {
                $search['include'] = $filter->forumId;
            }
            if($filter->topicId)
            {

            }
            if($filter->searchTime)
            {

            }
            if($filter->onlyIn)
            {
                $search['include'] = $filter->onlyIn;
            }
            if($filter->notIn)
            {
                $search['exclude'] = $filter->notIn;
            }
            if($filter->keywords)
            {
                $search['keywords'] = $filter->keywords;
            }

            try {
                $result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    $nodeIds = array();
                    $oMbqDataPage->totalNum = $result['totalRecords'];
                    $arrRecord = $result['results'];
                    foreach ($arrRecord as $postRecord) {
                        $nodeIds[] = $postRecord['nodeid'];
                    }
                } else {
                    $oMbqDataPage->totalNum = 0;
                    $nodeIds = array();
                }
            }
            catch (Exception $e) {
                $oMbqDataPage->totalNum = 0;
                $nodeIds = array();
            }
            if($filter->showPosts)
            {
                $oMbqRdEtForumPost = MbqMain::$oClk->newObj('MbqRdEtForumPost');
                $mbqOpt['case'] = 'byPostIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                return $oMbqRdEtForumPost->getObjsMbqEtForumPost($nodeIds, $mbqOpt);
            }
            else
            {
                $mbqOpt['case'] = 'byTopicIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
                return $oMbqRdEtForumTopic->getObjsMbqEtForumTopic($nodeIds, $mbqOpt);
            }
        }
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE);
    }
}

