<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseRdEtUser');

/**
 * user read class
 */
Class MbqRdEtUser extends MbqBaseRdEtUser {

    public function __construct() {
    }

    public function makeProperty(&$oMbqEtUser, $pName, $mbqOpt = array()) {
        switch ($pName) {
            default:
                MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_PNAME . ':' . $pName . '.');
                break;
        }
    }

    /**
     * get user objs
     *
     * @param  Mixed  $var
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'byUserIds' means get data by user ids.$var is the ids.
     * @mbqOpt['case'] = 'online' means get online user.
     * @return  Array
     */
    public function getObjsMbqEtUser($var, $mbqOpt) {
        if ($mbqOpt['case'] == 'byUserIds') {
            $objsMbqEtUser = array();
            foreach ($var as $userId) {
                if(MbqMain::$Cache->Exists('MbqEtUser',$userId))
                {
                    $objsMbqEtUser[] = MbqMain::$Cache->Get('MbqEtUser',$userId);
                }
                else
                {
                    try {
                        $result = vB_Api::instanceInternal('user')->fetchProfileInfo($userId);
                        if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                            $oMbqEtUser = $this->initOMbqEtUser($result, array('case' => 'userRecord'));
                            if($oMbqEtUser != null)
                            {
                                MbqMain::$Cache->Set('MbqEtUser',$userId, $oMbqEtUser);
                                $objsMbqEtUser[] = $oMbqEtUser;
                            }
                        } else {
                            MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . "Can not get user profile.");
                        }
                    }
                    catch (Exception $e) {
                        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . "Can not get user profile.");
                    }
                }
            }
            return $objsMbqEtUser;
        } elseif ($mbqOpt['case'] == 'searchByName') {
            $oMbqDataPage = $mbqOpt['oMbqDataPage'];

            require_once(DIR . '/includes/class_core.php');
            require_once(DIR . '/includes/adminfunctions_user.php');
            require_once(DIR . '/includes/adminfunctions_profilefield.php');

            $db = vB::getDbAssertor();

            $condition = array('field' => "user.username", 'value' => vB_String::htmlSpecialCharsUni($var),
                 'operator' => vB_dB_Query::OPERATOR_INCLUDES);

			$conditions[] = $condition;
            $countusers = $db->getField('userFindCount', array(
                'filters' => $conditions,
                'exceptions' => array(),
                'unions' => array(),
            ));

            $users = $db->getRows('userFind', array(
                'filters' => $conditions,
                'exceptions' => array(),
                'unions' =>  array(),
                'orderby' => 'username',
                'direction' => 'ASC',
                'limitstart' => $oMbqDataPage->startNum,
                vB_dB_Query::PARAM_LIMIT => $oMbqDataPage->numPerPage,
            ));
            $oMbqDataPage->totalNum = $countusers;
            if ($countusers != 0)
            {
                $userIds = array();
                foreach($users as $user)
                {
                    $userIds[] = $user['userid'];
                }
                $oMbqDataPage->datas = $this->getObjsMbqEtUser($userIds, array('case' => 'byUserIds'));
            }

            return $oMbqDataPage;
        } elseif ($mbqOpt['case'] == 'online') {
            try {
                $oMbqDataPage = $mbqOpt['oMbqDataPage'];
                $result = vB_Api::instance('wol')->fetchAll();
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    $userIds = array();
                    foreach ($result as $record) {
                        if ($record['userid']) {
                            $userIds[] = $record['userid'];
                        }
                    }
                    $users = $this->getObjsMbqEtUser($userIds, array('case' => 'byUserIds'));
                    foreach ($result as $record) {
                        if (isset($record['userid']) && isset($record['wol'])) {
                            foreach($users as $user) {
                                if ($record['userid'] == $user->userId->oriValue) {
                                    $message = vB_Phrase::fetchSinglePhrase($record['wol']['action'], $record['wol']['params']);
                                    $user->displayText->setOriValue(strip_tags($message));
                                }
                            }
                        }
                    }
                    $oMbqDataPage->datas = $users;
                    $oMbqDataPage->totalNum = sizeof($users);
                    return $oMbqDataPage;
                } else {
                    MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . "Can not get online user.");
                }
            }
            catch (Exception $e) {
                MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . "Can not get online user.");
            }
        }
        else if($mbqOpt['case'] == 'ignored')
        {
            $oMbqDataPage = $mbqOpt['oMbqDataPage'];
            $assertor = vB::getDbAssertor();
            $context = vB::getUserContext();
            $loggedUserid = $context->fetchUserId();

            $ignoredUsersQuery = $assertor->getRows('userlist', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
                'userid' => $loggedUserid,
                'type' => 'ignore', 'friend' => 'denied'));
            $ignoredUsersIds = array();

            foreach($ignoredUsersQuery as $ignoredUser)
            {
                $ignoredUsersIds[] = $ignoredUser['relationid'];
            }
            $oMbqDataPage->totalNum = sizeof($ignoredUsersIds);
            $ignoredUsersIds = array_slice($ignoredUsersIds, $oMbqDataPage->startNum, $oMbqDataPage->numPerPage);

            $users = $this->getObjsMbqEtUser($ignoredUsersIds, array('case' => 'byUserIds'));
            $oMbqDataPage->datas = $users;
            return $oMbqDataPage;
        }
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE . ' ' .$mbqOpt['case']);
    }

    /**
     * init one user by condition
     *
     * @param  Mixed  $var
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'userRecord' means init user by userRecord.$var is userRecord.
     * $mbqOpt['case'] = 'byUserId' means init user by user id.$var is user id.
     * $mbqOpt['case'] = 'byLoginName' means init user by login name.$var is login name.
     * @return  Mixed
     */
    public function initOMbqEtUser($var, $mbqOpt) {
        global $vbulletin;
        switch($mbqOpt['case'])
        {
            case 'userRecord':
                {
                    if(!isset($var['userid']))
                    {
                        return null;
                    }
                    $context = vB::getUserContext();
                    $loggedUserid = $context->fetchUserId();
                    $isCurrentLoggedUser = ($loggedUserid == $var['userid']);
                    $oMbqEtUser = MbqMain::$oClk->newObj('MbqEtUser');
//                    $userinfo = vB_User::fetchUserinfo($var['userid'], array(vB_Api_User::USERINFO_AVATAR, vB_Api_User::USERINFO_PROFILEPIC,   vB_Api_User::USERINFO_ADMIN, vB_Api_User::USERINFO_SIGNPIC));
                    $userinfo = vB_User::fetchUserinfo($var['userid']);
                    if (!empty($var['email']))
                    {
                        $oMbqEtUser->userEmail->setOriValue($var['email']);
                    }
                    else
                    {
                        $oMbqEtUser->userEmail->setOriValue($userinfo['email']);
                    }
                    $oMbqEtUser->userId->setOriValue($var['userid']);
                    $oMbqEtUser->loginName->setOriValue(mobiquo_encode($var['username']));
                    $oMbqEtUser->userName->setOriValue(mobiquo_encode($var['username']));
                    $oMbqEtUser->userGroupIds->setOriValue(array($var['usergroupid']));
                    $oMbqEtUser->userType->setOriValue(get_usertype_by_grpid($var['usergroupid']));
                    $iconUrl = vB_Api::instanceInternal('user')->fetchAvatar($var['userid'], false);
                    $iconUrl = $iconUrl['avatarpath'];
                    $iconUrl = MbqMain::$oMbqAppEnv->baseUrlCore . '/' . $iconUrl;
                    $oMbqEtUser->iconUrl->setOriValue($iconUrl);
                    $oMbqEtUser->canSearch->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.canSearch.range.yes'));
                    if (MbqMain::$oMbqAppEnv->exttOptions['enablepms']) {
                        $pmApi = vB_Api::instanceInternal('content_privatemessage');
                        if ($pmApi->canUsePmSystem($var['userid']))
                        {
                            $oMbqEtUser->canPm->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.canPm.range.yes'));
                            if ($var['receivepm']) {
                                $oMbqEtUser->acceptPm->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.acceptPm.range.yes'));
                            }
                            $oMbqEtUser->canSendPm->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.canSendPm.range.yes'));
                        }
                    }
                    if($isCurrentLoggedUser)
                    {
                        $oMbqEtUser->postCount->setOriValue($var['posts']);

                        if(!isset($var['adminpermissions']))
                        {
                            $oMbqEtUser->postCountdown->setOriValue(MbqMain::$oMbqAppEnv->exttOptions['floodchecktime']);
                        }
                        $currentUserContext = vB::getUserContext();
                        if ($currentUserContext->hasPermission('wolpermissions', 'canwhosonline'))
                        {
                            $oMbqEtUser->canWhosonline->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.canWhosonline.range.yes'));
                        }

                        $permissions = cache_permissions($userinfo, false);
                        if(vB::getUserContext()->isModerator()) $oMbqEtUser->canModerate->setOriValue(MbqBaseFdt::getFdt('MbqFdtUser.MbqEtUser.canSendPm.range.yes'));
                        $oMbqEtUser->maxAttachment->setOriValue(MbqMain::$oMbqAppEnv->exttOptions['maximages']);
                        $oMbqEtUser->maxPngSize->setOriValue(MbqMain::$oMbqAppEnv->exttAttachmentcache['png']['size']);
                        $jpgMaxSize = MbqMain::$oMbqAppEnv->exttAttachmentcache['jpg']['size'];
                        $jpegMaxSize = MbqMain::$oMbqAppEnv->exttAttachmentcache['jpeg']['size'];
                        $oMbqEtUser->maxJpgSize->setOriValue($jpgMaxSize > $jpegMaxSize ? $jpgMaxSize : $jpegMaxSize);
                        $oMbqEtUser->canUploadAvatar->setOriValue($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar'] ? true : false);
                        $oMbqEtUser->maxAvatarSize->setOriValue($userinfo['permissions']['avatarmaxsize']);
                        $oMbqEtUser->maxAvatarWidth->setOriValue($userinfo['permissions']['avatarmaxwidth']);
                        $oMbqEtUser->maxAvatarHeight->setOriValue($userinfo['permissions']['avatarmaxheight']);

                        $types = vB::getDbAssertor()->assertQuery('vBForum:attachmenttype', array(), array('extension'));
                        $extensions = array();
                        foreach ($types as $type)
	                    {
                            $extensions[] = $type['extension'];
                        }
                        $extensions = implode(',', $extensions);
                        $oMbqEtUser->allowedExtensions->setOriValue($extensions);

                        $assertor = vB::getDbAssertor();
                        $ignoredUsersQuery = $assertor->getRows('userlist', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
            				'userid' => $var['userid'],
				            'type' => 'ignore', 'friend' => 'denied'));
                        $ignoredUsersIds = array();
                        foreach($ignoredUsersQuery as $ignoredUser)
                        {
                            $ignoredUsersIds[] = $ignoredUser['relationid'];
                        }
                        $ignoredUsers = implode(',',$ignoredUsersIds);
                        $oMbqEtUser->ignoredUids->setOriValue($ignoredUsers);
                        $oMbqEtUser->isIgnored->setOriValue(false);
                    }
                    else
                    {
                        $oMbqEtUser->isIgnored->setOriValue(MbqCm::checkIfUserIsIgnored($var['userid']));
                    }
                    if ($var['status']) {
                        $displayText = $var['status'];
                    } else {
                        $displayText = $var['usertitle'];
                    }
                    $canBan = true;
                    if (!$context->hasAdminPermission('cancontrolpanel') AND !$context->hasPermission('moderatorpermissions', 'canbanusers'))
                    {
                        $canBan = false;
                    }
                    $oMbqEtUser->canBan->setOriValue($canBan);
                    $oMbqEtUser->isBan->setOriValue(vB_Library::instance('user')->isBanned($var['userid']));
                    $oMbqEtUser->displayText->setOriValue($displayText);
                    $oMbqEtUser->regTime->setOriValue($var['joindate']);
                    $oMbqEtUser->lastActivityTime->setOriValue($var['lastactivity']);

                    $oMbqEtUser->mbqBind['userRecord'] = $var;
                    return $oMbqEtUser;
                    break;
                }
            case 'byUserId':
                {
                    if(MbqMain::$Cache->Exists('MbqEtUser',$var))
                    {
                        return MbqMain::$Cache->Get('MbqEtUser',$var);
                    }
                    $result = vB_Api::instanceInternal('user')->fetchProfileInfo($var);
                    if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                        if ($result) {
                            $oMbqEtUser = $this->initOMbqEtUser($result, array('case' => 'userRecord'));
                            MbqMain::$Cache->Set('MbqEtUser',$var, $oMbqEtUser);
                        } else {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    return $oMbqEtUser;
                    break;
                }
            case 'byEmail':
                {
                    try {
                        $var = vB_String::htmlSpecialCharsUni($var);
                        $result = vB_Api::instanceInternal('user')->fetchByEmail($var);
                        if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)
                            ) {
                            if ($result
                                ) {
                                return $this->initOMbqEtUser($result['userid'], array('case' => 'byUserId'));
                            } else {
                                return null;
                            }
                        } else {
                            return null;
                        }
                    }
                    catch (Exception $e) {
                        return null;
                    }
                    break;
                }
            case 'byLoginName':
                {
                    try {
                        $var = vB_String::htmlSpecialCharsUni($var);
                        $result = vB_Api::instanceInternal('user')->fetchByUsername($var);
                        if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)
                            ) {
                            if ($result
                                ) {
                                return $this->initOMbqEtUser($result['userid'], array('case' => 'byUserId'));
                            } else {
                                return null;
                            }
                        } else {
                            return null;
                        }
                    }
                    catch (Exception $e) {
                        return null;
                    }
                    break;
                }
            default:
                {
                    MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE . ' -> ' . $mbqOpt['case']);
                }
        }
    }

    /**
     * get user display name
     *
     * @param  Object  $oMbqEtUser
     * @return  String
     */
    public function getDisplayName($oMbqEtUser) {
        //return $oMbqEtUser->loginName->oriValue;
        return htmlspecialchars_decode($oMbqEtUser->loginName->oriValue);
    }

    /**
     * login
     *
     * @param  String  $loginName
     * @param  String  $password
     * @return  Boolean  return true when login success.
     */
    public function login($login, $password, $anonymous, $push) {
        try {
            $result = vB_Api::instance('user')->login($login, $password);
            if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                if ($result['userid']) {
                    $newResult = vB_Api::instance('user')->fetchCurrentUserinfo();
                    if ($newResult['userid']) {
                        vB5_Cookie::set('cpsession', isset($result['cpsession']) ? $result['cpsession']: '', 30);
                        vB5_Cookie::set('sessionhash', $result['sessionhash'], 30);
                        vB5_Cookie::set('userid', $result['userid'], 30);
                        MbqMain::$oMbqAppEnv->currentUserInfo = $newResult;
                        $this->initOCurMbqEtUser($result['userid']);
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return MbqMain::$oMbqAppEnv->exttGetErrorMessage($result['errors'][0]);
            }
        }
        catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function loginDirectly($oMbqEtUser, $trustCode) {

        $session = vB::getRequest()->createSessionForUser($oMbqEtUser->userId->oriValue);
        $userinfo = vB_User::processNewLogin(array('userid'=>$oMbqEtUser->userId->oriValue));
        vB5_Cookie::set('cpsession', isset($userinfo['cpsession']) ? $userinfo['cpsession']: '', 30);
        vB5_Cookie::set('sessionhash', $userinfo['sessionhash'], 30);
        vB5_Cookie::set('userid', $userinfo['userid'], 30);

        MbqMain::$oMbqAppEnv->currentUserInfo = $userinfo;

        return $this->doLogin();
    }

    private function doLogin()
    {
        $this->initOCurMbqEtUser(MbqMain::$oMbqAppEnv->currentUserInfo['userid']);
        return true;
    }

    /**
     * init current user obj if login
     */
    public function initOCurMbqEtUser($userId) {
        if (MbqMain::$oMbqAppEnv->currentUserInfo) {
            MbqMain::$oCurMbqEtUser = $this->initOMbqEtUser(MbqMain::$oMbqAppEnv->currentUserInfo['userid'], array('case' => 'byUserId'));
        }
    }

    /**
     * logout
     *
     * @return  Boolean  return true when logout success.
     */
    public function logout() {
        $newResult = vB_Api::instance('user')->fetchCurrentUserinfo();
        if ($newResult['userid']) {
            try {
                $result = vB_Api::instance('user')->logout($newResult['logouthash']);
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    return true;
                } else {
                    return false;
                }
            }
            catch (Exception $e) {
                return false;
            }
        }
        return false;
    }

    public function getCustomRegisterFields()
    {
        $required_custom_fields = array();
        $db = vB::getDBAssertor()->getDBConnection();
        $vb_api_phrase = vB_Api::instanceInternal('phrase');
        $profilefields = $db->query_read_slave(" SELECT *
        FROM " . TABLE_PREFIX . "profilefield
        WHERE editable > 0 AND required <> 0
        ORDER BY displayorder" );
        while ($profilefield = $db->fetch_array($profilefields)){
            if($profilefield['required'] == 2) continue;
            $profilefieldname = "field$profilefield[profilefieldid]";
            //fetch_phrase();
            $profilefield_title      = $vb_api_phrase->fetch("{$profilefieldname}_title");
            $profilefield_desc       = $vb_api_phrase->fetch("{$profilefieldname}_desc");
            $profileFieldTitleValues = array_values($profilefield_title);
            $profilefield['title']         = $profileFieldTitleValues[0];
            $profileFieldDescValues = array_values($profilefield_desc);
            $profilefield['description']   = $profileFieldDescValues[0];
            if(in_array($profilefield['type'], array('checkbox', 'select_multiple')))
            {
                $profilefield['type'] = 'cbox';
            }
            else if($profilefield['type'] == 'select')
            {
                $profilefield['type'] = 'radio';
            }
            else if($profilefield['type'] == 'textarea')
            {
                $profilefield['type'] = 'input';
            }

            $custom_field_data = array(
                'name'          => $profilefield['title'],
                'description'   => $profilefield['description'],
                'type'          => $profilefield['type'],
                'key'           => $profilefieldname,
            );

            $options = '';
            if(in_array($profilefield['type'], array('radio', 'cbox')))
            {
                $data = unserialize($profilefield['data']);

                foreach ($data AS $key => $val)
                {
                    $val = $val;
                    $key += 1;
                    $options .= "$key=$val|";
                }
                $options = chop($options, '|');
                if($profilefield['type'] == 'radio' && isset($profilefield['def']) && !empty($profilefield['def']))
                {
                    $default = $profilefield['def'];
                }
            }
            else if($profilefield['type'] == 'input')
            {
                $default = $profilefield['data'];
            }

            if(isset($default) && !empty($default))
            {
                $custom_field_data['default'] = $default;
            }
            if(!empty($options))
            {
                $custom_field_data['options'] = $options;
            }

            $required_custom_fields[] = $custom_field_data;
        }

        return $required_custom_fields;
    }

    /**
     * forget_password
     *
     * @return Array
     */
    public function forgetPassword($oMbqEtUser) {
    	$api = Api_InterfaceAbstract::instance();

        //hvcheck input
        $vb_api_hv = vB_Api::instanceInternal('hv');
        $hvcheck = '';
        if ($vb_api_hv->fetchRequireHvcheck('lostpw'))
        {
            $vb_api_hv->generateToken();
            $rudb = vB::getDBAssertor()->getDBConnection();
            $hv_result = $rudb->query_first(" SELECT *
                FROM " . TABLE_PREFIX . "humanverify WHERE viewed = 0
                ORDER BY dateline DESC LIMIT 1" );
            $hvcheck = array('input' => $hv_result['answer'], 'hash' => $hv_result['hash']);
        }

        $response = $api->callApi('user', 'emailPassword', array('userid' => 0, 'email' => $oMbqEtUser->userEmail->oriValue, 'hvinput' => $hvcheck));

        if ($response === null)
            return true;
        else
        {
            $error_msg = $response['errors'][0][0];
            $error_msg = str_replace('_', " ", $error_msg);
            if (empty($error_msg))
                $error_msg = 'reset password failed!';
            return $error_msg;
        }
    }

    /**
     * the response should be bool to indicate if the username meet the forum requirement
     *
     * @param string $username
     */
    public function validateUsername($username){
        $result = vB_Api::instanceInternal('user')->fetchByUsername($username);
        if($result)
        {
            return false;
        }
        return true;
    }

    /**
     * the response should be bool to indicate if the password meet the forum requirement
     *
     * @param string $password
     */
    public function validatePassword($password){
        if(trim($password) == '')
        {
            return false;
        }
        return true;
    }
}
