<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseRdEtLike');

/**
 * Like read class
 */
Class MbqRdEtLike extends MbqBaseRdEtLike {
    
    public function __construct() {
    }
    
    public function makeProperty(&$oMbqEtLike, $pName, $mbqOpt = array()) {
        switch ($pName) {
            default:
            MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_PNAME . ':' . $pName . '.');
            break;
        }
    }

    public function getLikeCount($var) {
        $likedCount = 0;
        if( vB::getUserContext()->hasPermission('genericpermissions', 'canseewholiked') ) //check permission
        {
            $reputationApi = vB_Api::instanceInternal('reputation');
            $likedCount = $reputationApi->fetchVotecount($var['nodeid']);   
        }
        return $likedCount;
    }

    public function getObjsMbqEtLike($var, $mbqOpt) {
        if ($mbqOpt['case'] == 'all') {
        	// print_r($var);exit;
            $reputationApi = vB_Api::instanceInternal('reputation');

 			$objsMbqEtLike = array();
            if( vB::getUserContext()->hasPermission('genericpermissions', 'canseewholiked') ) //check permission
            {
            	$likeRecords = $reputationApi->fetchWhovoted($var['nodeid']);
            	foreach ($likeRecords as $likeRecord) {
                	$objsMbqEtLike[] = $this->initOMbqEtLike($likeRecord, array('case' => 'likeRecord', 'nodeid' => $var['nodeid'], 'post_time' => $var['created']));
                }
            }

            return $objsMbqEtLike;
        } 
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE);
    }
    
    public function initOMbqEtLike($var,$mbqOpt)
    {
        if($mbqOpt['case'] == 'likeRecord')
        {
            $oMbqEtLike = MbqMain::$oClk->newObj('MbqEtLike');
            $oMbqEtLike->key->setOriValue($mbqOpt['nodeid']);
            $oMbqEtLike->userId->setOriValue($var['userid']);
            $oMbqEtLike->type->setOriValue('post');
            $oMbqEtLike->postTime->setOriValue($mbqOpt['post_time']);

            $oMbqEtUser = MbqMain::$oClk->newObj('MbqEtUser');
            $oMbqEtUser->userId->setOriValue($var['userid']);
            $oMbqEtUser->reputation->setOriValue($var['reputation']);
            $oMbqEtUser->userName->setOriValue($var['username']);
            $oMbqEtUser->userGroupIds->setOriValue(array($var['usergroupid']));
            $oMbqEtUser->displayText->setOriValue($var['usertitle']);
            $iconUrl = MbqMain::$oMbqAppEnv->baseUrlCore . '/' . $var['avatarurl'];
            $oMbqEtUser->iconUrl->setOriValue($iconUrl);
            $oMbqEtLike->oMbqEtUser = $oMbqEtUser;

            return $oMbqEtLike;
        }
       
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE);
    }

  
}
