<?php

defined('MBQ_IN_IT') or exit;

/**
 * common method class
 */
Class MbqCm extends MbqBaseCm {

    public function __construct() {
        parent::__construct();
    }



    /**
     * get attachment ids from content
     * here return filedataids from content
     *
     * @params  String  $content
     * @return  Array
     */
    public function getAttIdsFromContent($content) {
        $result = array();
        preg_match_all('/\[img\].*?\/fetch\?id=([0-9]{1,10}).*?\[\/img\]/i', $content, $match);
        if ($match[1]) {
            $result = $match[1];
        } else {
            preg_match_all('/\[url.*?\/fetch\?id=([0-9]{1,10}).*?\[\/url\]/i', $content, $match);
            if ($match[1])
            {
                $result =  $match[1];
            }
            else
            {
                preg_match_all('/\[ATTACH=JSON\]([^\[]*?)\[\/ATTACH\]/i', $content, $match);
                if ($match[1])
                {
                    foreach($match[1] as $m)
                    {
                         $attachData = json_decode($m,true);
                         if(isset($attachData['data-attachmentid']))
                         {
                             $result[] = $attachData['data-attachmentid'];
                         }
                    }
                }
            }
        }
        return $result;
    }

    /**
     * convert app attachment bbcode to vb5 native code
     *
     * @param  String  $content
     * @return  String
     */
    public function exttConvertAppAttBbcodeToNativeCode($content) {
        //$content = preg_replace('/\[ATTACH\]([^\[]*?)\[\/ATTACH\]/i', '[IMG]'.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?filedataid=$1[/IMG]', $content);
        $content = preg_replace('/\[ATTACH\]([^\[]*?)\[\/ATTACH\]/i', '', $content);
        $content = preg_replace('/\[youtube\](.*?)\[\/youtube\]/i', '[video]$1[/video]', $content);
        $content = preg_replace('/\[vimeo\](.*?)\[\/vimeo\]/i', '[video]$1[/video]', $content);
        $content = str_replace(PHP_EOL, '<br/>' , $content);
        return $content;
    }

}
