<?php
class tapatalk_Api_Content_Text extends vB_Api_Extensions
{
    public $product = 'tapatalk';   //productid
    public $version = '1.3.6';      //tapatalk version
    public $title = 'Tapatalk';
    public $minver = '5.1.0';       //min sys version that can use this hook

    public $AutoInstall = 0;        // 1 will check and update automatically while 0 not
    public $extensionOrder = 5;

    public $options;

    /**
     *
     * @param  int  $getval  this is the value returned form function 'add($data, $options = array())' in text.php
     * The other params are just the same to the hook-from function
     *
     */
    public function add($getval, $data, $options = array())
    {
        if(is_bool($getval) === true) //if $getval is not a nodeid, return here.
            return $getval;

        try{
            $topicType = vB_Types::instance()->getContentTypeID('vBForum_Channel');
            $postType = vB_Types::instance()->getContentTypeID('vBForum_Text');
            $parentNode = vB_Library::instance('node')->getNode($data['parentid']);
            $contenttypeid = $parentNode['contenttypeid'];
            $topChannels = vB_Api::instanceInternal('content_channel')->fetchTopLevelChannelIds();
 			$forumparentid = $topChannels['forum'];
            //judge if topic or post
            $isTopicOrPost = false;
            $loopParentId =  $parentNode['parentid'];
            $parentDetail = array();
            while(!empty($loopParentId))
            {
                if($loopParentId == $forumparentid){
                    $isTopicOrPost = true;
                    break;
                }
                $loopParentNode = vB_Library::instance('node')->getNode($loopParentId);
                $parentDetail[] = $loopParentNode;
                $loopParentId = $loopParentNode['parentid'];
            }
            $addType = null;
            if($isTopicOrPost && $contenttypeid == $topicType)
                $addType = 'topic';
            elseif($isTopicOrPost && $contenttypeid == $postType)
                $addType = 'post';


            if(!defined('IN_MOBIQUO')){
                $vboptions = vB::get_datastore()->get_value('options');
                $tt_dir = $vboptions['tapatalk_directory'];
                define('MBQ_DS_TT', DIRECTORY_SEPARATOR);
                define('MBQ_PATH', ".".MBQ_DS_TT."{$tt_dir}".MBQ_DS_TT);
                require_once(MBQ_PATH."mobiquoCommon.php");
                include_once(MBQ_PATH."push".MBQ_DS_TT."TapatalkPush.php");
            }
            $oTapatalkPush = new TapatalkPush();
            if($addType == 'topic'){
                $push_data['id'] = $getval;
                $push_data['subid'] = $getval;
                $push_data['title'] = $data['title'];
                $push_data['subfid'] = $parentNode['nodeid'];
                $push_data['sub_forum_name'] = $parentNode['title'];
                $push_data['dateline'] = $data['created'];
                $push_data['content'] = $data['rawtext'];
                $oTapatalkPush->doPushNewtopic($push_data);
            }
            elseif($addType == 'post'){
                $push_data['id'] = $parentNode['nodeid'];
                $push_data['subid'] = $getval;
                $push_data['title'] = $parentNode['title'];
                $push_data['subfid'] = $parentDetail[0]['nodeid'];
                $push_data['sub_forum_name'] = $parentDetail[0]['title'];
                $push_data['dateline'] = $data['created'];
                $push_data['content'] = $data['rawtext'];
                $oTapatalkPush->doPushReply($push_data);
            }
        } catch (Exception $e) {
            error_log("Caught Tapatalk Push Error $e");
        }

        return $getval;
    }
}
