<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'login');
//define('CSRF_PROTECTION', true);
define('CSRF_SKIP_LIST', 'login');
define('CONTENT_PAGE', false);
if (!defined('VB_ENTRY'))
{
	define('VB_ENTRY', 1);
}
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
global $phrasegroups, $specialtemplates, $globaltemplates, $actiontemplates, $show;
$phrasegroups = ['global', 'cpglobal'];

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array(
	'lostpw' => array(
		'lostpw',
		'humanverify'
	)
);

//init the language since it doesn't quite work here otherwise.
global $vbulletin, $vbphrase;
$session = vB::getCurrentSession();
$session->clearUserInfo();

//init language logic salvaged from the legacy bootstrap
require_once(dirname(__FILE__) . '/includes/init.php');
fetch_options_overrides($vbulletin->userinfo);
fetch_time_data();
vB_Language::preloadPhraseGroups($phrasegroups);
$vbphrase = init_language();

//init style logic salvaged from the legacy bootstrap
//as far as I can tell we only need this for the charset because, for not so great reasons,
//we read this from the stylevars.  And only sometimes.
$styleid = $vbulletin->userinfo['styleid'];
$style = vB_Library::instance('style')->getStyleById($styleid);
$vbulletin->stylevars = $style['newstylevars'];
fetch_stylevars($style, $vbulletin->userinfo);

require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/functions_login.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (empty($_REQUEST['do']))
{
	exec_header_redirect(vB5_Route::buildUrl('home|fullurl'));
}

// ############################### start do login ###############################
// this was a _REQUEST action but where do we all login via request?
if ($_POST['do'] == 'login')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'vb_login_username'        => vB_Cleaner::TYPE_STR,
		'vb_login_password'        => vB_Cleaner::TYPE_STR,
		'vb_login_md5password'     => vB_Cleaner::TYPE_STR,
		'vb_login_md5password_utf' => vB_Cleaner::TYPE_STR,
		'vb_login_mfa_authcode'    => vB_Cleaner::TYPE_NOHTML,
		'postvars'                 => vB_Cleaner::TYPE_BINARY,
		'cookieuser'               => vB_Cleaner::TYPE_BOOL,
		'logintype'                => vB_Cleaner::TYPE_STR,
		'cssprefs'                 => vB_Cleaner::TYPE_STR,
		'inlineverify'             => vB_Cleaner::TYPE_BOOL,
	));

	$passwords = array(
		'password' => $vbulletin->GPC['vb_login_password'],
		'md5password' => $vbulletin->GPC['vb_login_md5password'],
		'md5password_utf' => $vbulletin->GPC['vb_login_md5password_utf'],
	);

	$extraAuth = array(
		'mfa_authcode' => $vbulletin->GPC['vb_login_mfa_authcode'],
	);

	$userApi = vB_Api::instance('user');
	$res = $userApi->login2($vbulletin->GPC['vb_login_username'], $passwords, $extraAuth, $vbulletin->GPC['logintype']);
	cache_permissions($vbulletin->userinfo);

	if(isset($res['errors']))
	{
		//we need the header here now that we know we won't be setting cookies.
		print_cp_header();

		$error = $res['errors'][0];
		$errorid = $error[0];
		$knownloginerror = (strpos($errorid, 'badmfa') === 0 OR strpos($errorid, 'badlogin') === 0 OR $errorid == 'strikes');

		//we should only be using this for a cp login at this point, but leaving this check in
		//in an abundance of caution.  Note that this redirect doesn't handle general errors
		//so we need to check if its one of the one's we do handle.  Otherwise use a more generic
		//error display below.
		if ($knownloginerror AND $vbulletin->GPC['logintype'] === 'cplogin' OR $vbulletin->GPC['logintype'] === 'modcplogin')
		{
			$url = unhtmlspecialchars($vbulletin->url);

			$urlarr = vB_String::parseUrl($url);

			$urlquery = $urlarr['query'] ?? '';

			$oldargs = array();
			if ($urlquery)
			{
				parse_str($urlquery, $oldargs);
			}

			$args = $oldargs;
			unset($args['loginerror']);

			$args['loginerror'] = $errorid;
			$args['strikes'] = getStrikes($error);
			$args['vb_login_username'] = $vbulletin->GPC['vb_login_username'];
			$argstr = http_build_query($args);

			$url = $urlarr['path'];

			if ($argstr)
			{
				$url .= '?' . $argstr;
			}

			print_cp_redirect(create_full_url($url));
		}

		print_stop_message2($error);
	}

	if ($vbulletin->GPC['logintype'] === 'cplogin')
	{
		vB_User::setAdminCss($res['userid'], $vbulletin->GPC['cssprefs']);
	}

	// set cookies (temp hack for admincp)
	if (isset($res['cpsession']))
	{
		vbsetcookie('cpsession', $res['cpsession'], false, true, true);
	}

	vbsetcookie('sessionhash', $res['sessionhash'], false, true, true);

	//this *has* to happen after the set cookies or bad things can happen.
	print_cp_header();
	do_login_redirect();
}
else if ($_GET['do'] == 'login')
{
	// add consistency with previous behavior
	exec_header_redirect(vB5_Route::buildUrl('home|fullurl'));
}

//we need to extract the strikes value from the error return because
//we can't really pass the url as a url parameter for XSS reasons
//this is ugly because we really don't want to unroll and the rewrap
//the error message on other end but until we can remove the redirect
//their isn't much of an option.
function getStrikes($error)
{
	$errorid = $error[0];

	//if this isn't a "strikes" error then we don't have strikes.
	if(strpos($errorid, 'strikes') === false)
	{
		return 0;
	}

	if(strpos($errorid, 'badmfa') === 0)
	{
		return $error[1];
	}

	if(strpos($errorid, 'badlogin') === 0)
	{
		return $error[2];
	}

	//note that the error "strikes" does not actually have any strikes to extract
	//but will pass the first check for strikes phrases.  Return 0
	return 0;
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 114020 $
|| #######################################################################
\*=========================================================================*/
