<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_574a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'routenew', 1, 1));

		//Reset the RE for conversation route to the default unless the route is custom.
		//(Non custom conversations routes should always be the default RE).
		//In this case to fix an issue when the title contains brackets.
		$db = vB::getDbAssertor();
		$routes = $db->assertQuery('routenew', ['class' => 'vB5_Route_Conversation']);
		foreach ($routes AS $route)
		{
			if (!empty($args['customUrl']))
			{
				continue;
			}

			$regex = preg_quote($route['prefix']) . '/' . vB5_Route_Conversation::REGEXP;
			$db->update('routenew', ['regex' => $regex], ['routeid' => $route['routeid']]);
		}
	}

	public function step_2($data = [])
	{
		if (empty($data['startat']))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'node', 1, 1));
		}

		//There isn't a great way to do the batching here.  We really want an efficient way to batch over all
		//nodes with a open or close bracket in the ident but there just isn't a good way to do that.  We either
		//need to scan for brackets on both the next id query and the process query, which is potentially a table
		//scan over a lot of data.  Or we can just scan over the process which has the problem of requiring
		//painfully small batch sizes, many of which may be empty, or the potentially hitting a batch with too many
		//hits to handle -- we expect a very few affected nodes but can't guarentee it.
		//
		//Hit upon the strategy of walking over all of the nodes in large batches and approximating the ident fix
		//instead of regenerating it entirely via code (which saves an update query for every affected node).
		//Because sql doesn't handle RE replacement gracefully (it's 8.0+ and buggy in some versions) we'll
		//have to do string replacements directly.  Which means that we might get duplicated '-' characters in
		//some cases instead of completely collapsing all sequences of '-' to a single one.  We'll live with it.
		$channeltypeid = vB_Types::instance()->getContentTypeID('vBForum_Channel');
		$walker = new vB_UpdateTableWalker(vB::getDBAssertor());
		$walker->setBatchSize($this->getBatchSize('xlarge', __FUNCTION__));
		$walker->setMaxQuery('vBInstall:getMaxNodeid');
		$walker->setNextidQuery('vBForum:node', 'nodeid');
		$walker->setCallbackQuery('vBInstall:replaceBracketsInTopicIdent', ['channeltypeid' => $channeltypeid]);

		return $this->updateByWalker($walker, $data);
	}

	// Update old header nav default items to use routeid
	public function step_3()
	{
		// first, ensure all routes we're going to use are imported
		//$this->ensureNavBarsRoutes();
		// Edit, importing routes actually requires importing everythign else first (pagetemplates, page, channel)
		// Let's just set the guids for missing routes, and then let upgrade_final clean it up.

		// Now, update the default items. This is tricky because we won't necessarily know which navitems
		// are default and which have been edited by the admin, but still has some of the same attributes.
		// We'll use title & url, and if they both match the default expected values, check the route. If the
		// route matches the expected target route guid, we'll assume it's default & add the route information.
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'site', 1, 1));

		$this->addRoutesToDefaultNavbars();
	}

	private function fetchNavbarRouteDefaults($navbar)
	{
		$defaults = [];
		foreach ($navbar AS $__item)
		{
			if (isset($__item['route_guid']))
			{
				$__key = $this->generateUniqueIDForNavitem($__item);
				// This should have url, title, route_guid
				$__copy = $__item;
				unset($__copy['subnav']);
				$defaults[$__key] = $__copy;
			}
			if (!empty($__item['subnav']))
			{
				$defaults = array_merge($defaults, $this->fetchNavbarRouteDefaults($__item['subnav']));
			}
		}

		return $defaults;
	}

	private function generateUniqueIDForNavitem($navitem)
	{
		// Let's use "title" & "url" of the defaults to identify each navitem/subitem entry
		return md5(json_encode([
			$navitem['title'],
			$navitem['url'],
		]));
	}

	private function fixDefaultNavbars(array &$navbar, array $defaultData, array $routes) : bool
	{
		$changed = false;
		foreach ($navbar AS &$__item)
		{
			$__key = $this->generateUniqueIDForNavitem($__item);
			// This indirectly checks that title & url match the defaults
			$__default = $defaultData[$__key] ?? null;
			if ($__default)
			{
				$__guid = $__default['route_guid'];
				$__route = $routes[$__guid] ?? [];
				// this is kind of sketchy
				$__urlMatchesCloseEnough = (
					strpos(trim($__route['prefix'] ?? '', '/'), trim($__default['url'], '/')) !== false
				);
				// If this is a default item (we think, per above), and...
				// If default expected route URL hasn't changed, and isn't a redirect (i.e admin did not change
				// the default page's URL), and this item isn't already associated with a routeid, then we can
				// probably change assume that this is a default navitem that wasn't modified, and can change
				// it to associate with the appropriate routes.
				$__doChange = ($__urlMatchesCloseEnough AND
					(
						// Importing routes requires first importing pagetemplates & pages (& possibly channels?)
						// We're just going to do that again in final upgrade, so let's just let this pass for now
						// and assume that if the route is missing, it's a new one that'll be imported in upgrade-final
						!$__route OR
						!$__route['redirect301'] AND empty($__item['routeid'])
					)
				);

				if ($__doChange)
				{
					if (!empty($__route['routeid']))
					{
						$__item['routeid'] = $__route['routeid'];
					}
					else
					{
						// We may not have this route imported yet.
						// Set it to guid and let upgrade final step_22
						// take care of fixing it.
						$__item['route_guid'] = $__default['route_guid'];
					}
					$changed = true;
				}
			}

			if (!empty($__item['subnav']))
			{
				$changed = $this->fixDefaultNavbars($__item['subnav'], $defaultData, $routes) || $changed;
			}
		}

		return $changed;
	}

	private function addRoutesToDefaultNavbars()
	{
		$siteId = 1;
		$navbars = get_default_navbars();
		$defaultData = array_merge(
			$this->fetchNavbarRouteDefaults($navbars['header']),
			$this->fetchNavbarRouteDefaults($navbars['footer'])
		);

		$guids = array_column($defaultData, 'route_guid');

		/** @var vB_Library_Site */
		$siteLib = vB_Library::instance('site');
		$assertor = vB::getDbAssertor();
		$routes = $assertor->getRows('routenew', ['guid' => $guids], false, 'guid');

		$site = vB::getDbAssertor()->getRow('vBForum:site', ['siteid' => $siteId]);
		$site['headernavbar'] = vB_Utility_Unserialize::unserialize($site['headernavbar'] ?? 'a:0:{}');
		$site['footernavbar'] = vB_Utility_Unserialize::unserialize($site['footernavbar'] ?? 'a:0:{}');

		// Need a session for route URL generation for the route_guid/routeid conversion to URLs downstream of saveNavbar calls...
		vB_Upgrade::createAdminSession();
		$changed = $this->fixDefaultNavbars($site['headernavbar'], $defaultData, $routes);
		if ($changed)
		{
			$siteLib->saveHeaderNavbar($siteId, $site['headernavbar'], true);
		}

		$changed = $this->fixDefaultNavbars($site['footernavbar'], $defaultData, $routes);
		if ($changed)
		{
			$siteLib->saveFooterNavbar($siteId, $site['footernavbar'], true);
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
