<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_572a4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'nodefieldcategorychannel'),
			"
				CREATE TABLE `" . TABLE_PREFIX . "nodefieldcategorychannel` (
					`nodeid` INT UNSIGNED NOT NULL DEFAULT '0',
					`nodefieldcategoryid` INT UNSIGNED NOT NULL DEFAULT '0',
					PRIMARY KEY (`nodeid`, `nodefieldcategoryid`)
				) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'nodefieldcategory'),
			"
				CREATE TABLE `" . TABLE_PREFIX . "nodefieldcategory` (
					`nodefieldcategoryid` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					`name` VARCHAR(50) NOT NULL DEFAULT '',
					`displayorder` INT UNSIGNED NOT NULL DEFAULT '0',
					UNIQUE KEY `name` (`name`)
				) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_3()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'nodefield'),
			"
				CREATE TABLE `" . TABLE_PREFIX . "nodefield` (
					`nodefieldid` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					`nodefieldcategoryid` INT UNSIGNED NOT NULL,
					`name` VARCHAR(50) NOT NULL DEFAULT '',
					`displayorder` INT UNSIGNED NOT NULL DEFAULT '0',
					`type` ENUM('input', 'select', 'radio', 'textarea', 'checkbox', 'select_multiple') NOT NULL DEFAULT 'input',
					KEY `nodefieldcategoryid` (`nodefieldcategoryid`),
					UNIQUE KEY `name` (`name`)
				) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_4()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'nodefieldvalue'),
			"
				CREATE TABLE `" . TABLE_PREFIX . "nodefieldvalue` (
					`nodefieldvalueid` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					`nodefieldid` INT UNSIGNED NOT NULL,
					`nodeid` INT UNSIGNED NOT NULL,
					`value` TEXT,
					UNIQUE KEY `nodeid_nodefieldid` (`nodeid`, `nodefieldid`),
					KEY `nodefieldid` (`nodefieldid`)
 				) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_5()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'routenew', 1, 1));

		//Reset the RE for conversation route to the default unless the route is custom.
		//(Non custom conversations routes should always be the default RE).
		//In this case to fix an issue when the title contains a space.
		$db = vB::getDbAssertor();
		$routes = $db->assertQuery('routenew', ['class' => 'vB5_Route_Conversation']);
		foreach ($routes AS $route)
		{
			if (!empty($args['customUrl']))
			{
				continue;
			}

			$regex = preg_quote($route['prefix']) . '/' . vB5_Route_Conversation::REGEXP;
			$db->update('routenew', ['regex' => $regex], ['routeid' => $route['routeid']]);
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
