<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_572a1 extends vB_Upgrade_Version
{
	// Steps 1-3 convert old index on paymentinfo.hash to a unique index, revert to old index if collision.
	public function step_1()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		// the $overwrite param for add_index does not work properly for this. It only seems to overwrite (i.e. drop the
		// old index before adding the new one) if the old index's constituent columns are different from the new index's
		// columns. As such we have to explicitly drop it before trying to add the new one.
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'paymentinfo', 1, 3),
			'paymentinfo',
			'hash'
		);
	}

	public function step_2()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		// See VBV-21266 -- this is extremely unlikely to hit an error, and there aren't great ways to automatically
		// "fix" a hash collision if it does happen. It'll require manual investigation and judgment on which hash to drop.
		// Most likely, it was some manual db changes/inserts that caused this. As such, IF a hash collision does happen
		// while trying to convert the index to UNIQUE, we're going to ignore it, then put the old non-unique index back.

		// Try to add index
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'paymentinfo', 2, 3),
			'paymentinfo',
			'hash',
			['hash', ],
			'unique',
			false,
			[self::MYSQL_ERROR_KEY_EXISTS, self::MYSQL_ERROR_UNIQUE_CONSTRAINT]
		);
	}

	public function step_3()
	{
		// See comment block in step_2(). If the unique index creation hit an error, just
		// quietly put the old index back.
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'paymentinfo', 3, 3),
			'paymentinfo',
			'hash',
			['hash', ]
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
