<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_571a4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->drop_field2('usertextfield', 'searchprefs');
	}

	public function step_2()
	{
		$this->drop_field2('session', 'bypass');
	}

	//copied from 553a4.  We need it both places because some older steps break if this the situation but
	//we need to clean up any newer DBs as well.
	public function step_3()
	{
		$datastore = vB::getDatastore();
		$defaultchannelpermissions = $datastore->getValue('defaultchannelpermissions');

		$changed = false;
		foreach($defaultchannelpermissions AS $node => $groups)
		{
			foreach($groups AS $group => $permissions)
			{
				foreach($permissions AS $name => $value)
				{
					//this should never be an array but a bug in caused arrays to be created instead of values overwritten
					//no good can come of this.  The last value in the array is the one most likely intended as the correct
					//value so we'll go with that.
					if (is_array($value))
					{
						$changed = true;
						$defaultchannelpermissions[$node][$group][$name] = end($value);
					}
				}
			}
		}

		if ($changed)
		{
			$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'defaultchannelpermissions'));
			$datastore->build('defaultchannelpermissions', serialize($defaultchannelpermissions), 1);
		}
		else
		{
			$this->skip_message();
		}
	}

	// Steps 4 & 5: Update answered topics in invalid states due to either the answer being soft/hard deleted, or the topic being soft deleted.
	// Edit: Also handle unapproved answers like soft-deleted answers
	// First, unset isanswer for soft-deleted answers
	// Then, fix any topics with either case.
	public function step_4()
	{
		$this->show_message(sprintf($this->phrase['version']['571a4']['unset_deleted_answers_x_of_y'], 1, 2));
		// I don't expect that there are enough relevant nodes to require batching.
		// The fetch query took about 1.7s on a 1m node database with ~60k artificially broken answers for testing.
		$assertor = vB::getDbAssertor();
		$assertor->assertQuery('vBInstall:fixSoftDeletedOrUnapprovedAnswers');
		$this->long_next_step();
	}

	public function step_5()
	{
		$this->show_message(sprintf($this->phrase['version']['571a4']['unset_deleted_answers_x_of_y'], 2, 2));
		// I don't expect that there are enough relevant nodes to require batching.
		// The query took about 5.3s on a 1million node database with 60k ~ 120k topics artificially broken for testing.
		// It's a bit slow, but should be well under any timeouts.
		$assertor = vB::getDbAssertor();
		$assertor->assertQuery('vBInstall:fixAnsweredNodesWithDeletedAnswers');
	}

	// Add admin message to let them know there's a new (empty) terms of service page
	public function step_6()
	{
		$this->add_adminmessage(
			'after_upgrade_check_tos_page',
			[
				'dismissable' => 1,
				'script'      => '',
				'action'      => '',
				'execurl'     => '',
				'method'      => 'get',
				'status'      => 'undone',
			]
		);
	}


	//Prep for step 8: Need to import the settings XML in case this install doesn't have the new option yet.
	public function step_7()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		vB_Library::clearCache();
		$this->final_load_settings();
	}

	/*
	 * Copy current threadpreview value into emailpreview. Run once only.
	 */
	public function step_8()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}
		vB_Upgrade::createAdminSession();
		$this->show_message($this->phrase['version']['571a4']['copying_threadpreview']);
		$options = vB::getDatastore()->getValue('options');
		if (isset($options['threadpreview']) AND isset($options['emailpreview']))
		{
			$this->set_option('emailpreview', 'email', intval($options['threadpreview']));
		}
	}


	public function step_9()
	{
		// Placeholder last step allow iRan() to work properly, as the last step gets recorded as step '0' in the upgrade log for CLI upgrade.
		$this->skip_message();
	}

}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
