<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_571a2 extends vB_Upgrade_Version
{
	// remove no longer used index
	public function step_1()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 1, 5),
			'ranks',
			'grouprank'
		);
	}

	public function step_2()
	{
		// Rename `ranks`.`displayorder` to `ranks`.`priority`, but only if we haven't already.
		// This is to block cases of accidentally trying to rename an actual displayorder column
		// if we add one in the future
		if ($this->field_exists('ranks', 'displayorder') AND !$this->field_exists('ranks', 'priority'))
		{
			$this->run_query(
				sprintf($this->phrase['core']['altering_x_table'], 'ranks', 2, 5),
				"ALTER TABLE " . TABLE_PREFIX . "ranks CHANGE displayorder priority INT NOT NULL DEFAULT 0"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	// add `ranks`.`grouping`
	public function step_3()
	{
		// grouping VARCHAR(191) NOT NULL DEFAULT '',
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 3, 5),
			'ranks',
			'grouping',
			'VARCHAR',
			[
				'length' => 191,
				'null'    => false,
				'default' => '',
			],
		);
	}

	// set `ranks`.`grouping` defaults to be associated with usergroup in order
	// to preserve old sorting behavior.
	public function step_4()
	{
		// only run once
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}
		$this->show_message($this->phrase['version']['571a1']['update_userrank_grouping']);
		// Old behavior was `usergroupid` DESC, `minposts` DESC.
		// Now we want `grouping` ASC, `priority` DESC, so
		$assertor = vB::getDbAssertor();
		$usergroupsById = $assertor->getColumn('vBForum:usergroup', 'title', [], false, 'usergroupid');
		$maxUsergroupId = max(array_keys($usergroupsById));
		$digits = strlen($maxUsergroupId);
		// Also add in the "All User Groups" default
		$usergroupsById[0] = "All User Groups";
		$ranks = $assertor->getRows('vBForum:ranks');
		foreach ($ranks AS $__rank)
		{
			$__ugid = $__rank['usergroupid'];
			// Need to preserve usergroupid DESC when we have goruping ASC, so "flip" the usergroupid
			$__prefix = str_pad(($maxUsergroupId - $__ugid), $digits, '0', STR_PAD_LEFT);
			$__usergroup = $usergroupsById[$__ugid] ?? "Unknow User Group";
			$__grouping = "$__prefix : $__usergroup";
			$assertor->update('vBForum:ranks', ['grouping' => $__grouping], ['rankid' => $__rank['rankid']]);
		}
	}

	// add new index
	public function step_5()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 4, 5),
			'ranks',
			'grouping',
			['grouping', ]
		);
	}

	// add new index (for joindate cron)
	public function step_6()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 5, 5),
			'ranks',
			'registrationtime',
			['registrationtime', ]
		);
	}

	// Trigger rebuild of ranks datastore array
	public function step_7()
	{
		$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'ranks'));
		vB::getDatastore()->delete('ranks');
		vB_Library::instance('userrank')->haveRanks();
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
