<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_571a1 extends vB_Upgrade_Version
{
	// Remove google checkout payment API
	public function step_1()
	{
		$assertor = vB::getDbAssertor();
		if ($assertor->getRow('vBForum:paymentapi', ['classname' => 'google']))
		{
			$this->show_message($this->phrase['version']['571a1']['removing_google_checkout']);

			// Remove any subscription specific options (e.g. display this payment option, tax, etc)
			$subs = $assertor->getColumn('vBForum:subscription', 'newoptions', [], false, 'subscriptionid');
			foreach ($subs AS $__id => $__newoptions)
			{
				$__newoptions = unserialize($__newoptions);
				if (isset($__newoptions['api']['google']))
				{
					unset($__newoptions['api']['google']);
					$__newoptions = serialize($__newoptions);
					$assertor->update('vBForum:subscription', ['newoptions' => $__newoptions], ['subscriptionid' => $__id]);
				}
			}

			$assertor->delete('vBForum:paymentapi', ['classname' => 'google']);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2($data = [])
	{
		if (empty($data['startat']))
		{
			$this->show_message($this->phrase['version']['571a1']['approve_privatemessages']);
		}

		$filter = ['contenttypeid' =>  vB_Types::instance()->getContentTypeID('vBForum_PrivateMessage')];

		$walker = new vB_UpdateTableWalker(vB::getDBAssertor());
		$walker->setBatchSize($this->getBatchSize('xlarge', __FUNCTION__));
		$walker->setMaxQuery('vBInstall:getMaxNodeidForContent', $filter);
		$walker->setNextidQuery('vBForum:node', 'nodeid', $filter);
		$walker->setCallbackQuery('vBInstall:setApprovedForPrivateMessages', $filter);

		return $this->updateByWalker($walker, $data);
	}

	// Steps 3 ~ 7 : Add new columns for user rank qualifiers
	public function step_3()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 1, 5),
			'ranks',
			'startedtopics',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
	}

	public function step_4()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 2, 5),
			'ranks',
			'registrationtime',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
	}

	public function step_5()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 3, 5),
			'ranks',
			'reputation',
			'INT',
			[
				// signed int
				'null'       => false,
				'default'    => 0,
			]
		);
	}

	public function step_6()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 4, 5),
			'ranks',
			'totallikes',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
	}

	public function step_7()
	{
		// This field was initially added as "displayorder" in a1, but renamed "priority" in a2.
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 5, 5),
			'ranks',
			'priority',
			'INT',
			[
				// signed int
				'null'       => false,
				'default'    => 0,
			]
		);
	}

	public function step_8()
	{
		// This used to rebuild ranks in datastore. I've since added/removed
		// some upgrade steps in the way, and this step has been moved to the end
		$this->skip_message();
		$this->long_next_step();
	}

	// add the startedtopics counter column & populate it.
	public function step_9()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 1),
			'user',
			'startedtopics',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
		$this->long_next_step();
	}

	public function step_10()
	{
		$this->show_message($this->phrase['version']['571a1']['adding_user_startedtopics']);

		// logic & queries are based on misc.php?do=updateposts
		$topChannels = vB_Library::instance('content_channel')->fetchTopLevelChannelIds();
		$checkChannels = [
			$topChannels['forum'],
			$topChannels['blog'],
			$topChannels['groups'],
		];

		$channelContentType = vB_Types::instance()->getContentTypeID('vBForum_Channel');
		$assertor = vB::getDbAssertor();
		$relevantChannelIds = $assertor->getColumn('vBInstall:fetchChannelsForPostCounts', 'nodeid', [
				'topLevelChannels' => $checkChannels,
				'channelContentTypeId' => $channelContentType,
			], false, 'nodeid');
		$assertor->assertQuery('vBInstall:updateUserStartedTopics', ['relevantChannelIds' => $relevantChannelIds]);
		$this->long_next_step();
	}

	// add the totallikes counter column & populate it.
	public function step_11()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 1),
			'user',
			'totallikes',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
		$this->long_next_step();
	}

	public function step_12()
	{
		$this->show_message($this->phrase['version']['571a1']['adding_user_totallikes']);
		$assertor = vB::getDbAssertor();
		$assertor->assertQuery('vBInstall:updateTotalLikes');
	}

	// Set priority to the same as minposts to preserve userrank collapse behavior
	// when a user qualifies for multiple ranks
	public function step_13()
	{
		$this->show_message($this->phrase['version']['571a1']['update_userrank_priority']);
		$assertor = vB::getDbAssertor();
		$assertor->assertQuery('vBInstall:updateUserrankPriority');
	}

	public function step_14()
	{
		// userrank rebuild moved to 571a2 because there are more changes to the userrank table.
		$this->skip_message();
	}

	// Add Square payment API
	public function step_15()
	{
		$assertor = vB::getDbAssertor();
		if (!$assertor->getRow('vBForum:paymentapi', ['classname' => 'square']))
		{
			$assertor->insert('vBForum:paymentapi', [
				'title'     => 'Square',
				'currency'  => 'usd',
				'recurring' => 0,
				'classname' => 'square',
				'active'    => 0,
				'settings'  => serialize([
					'app_id' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'access_token' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'webhook_url' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'webhook_signaure_key' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'sandbox' => [
						'type' => 'yesno',
						'value' => 0,
						'validate' => 'boolean'
					],
				]),
				'subsettings' => serialize([
					'show' => [
						'type' => 'yesno',
						'value' => 1,
						'validate' => 'boolean'
					],
					'tax' => [
						'type' => 'yesno',
						'value' => 0,
						'validate' => 'boolean'
					],
					'tax_name' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'tax_percentage' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'number'
					],
					'tax_behavior' => [
						'type' => 'select',
						'options' => ['inclusive', 'additive'],
						'value' => 'inclusive',
						'validate' => 'string'
					],
				]),
			]);
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'paymentapi', 1, 1));
		}
		else
		{
			$this->skip_message();
		}
	}

	// helper tables to handle Square idiosyncrasies... catalog info tracking & intermediary mappers
	// for relational data that's missing exposure in Square API.
	public function step_16()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'paymentapi_remote_catalog'),
			"
			CREATE TABLE " . TABLE_PREFIX . "paymentapi_remote_catalog (
				paymentapiid INT UNSIGNED NOT NULL DEFAULT 0,
				vbsubscriptionid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				vbsubscription_subid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				remotecatalogid VARCHAR(150) NOT NULL DEFAULT '',
				data MEDIUMTEXT NOT NULL DEFAULT '',
				active SMALLINT NOT NULL DEFAULT 1,
				PRIMARY KEY (paymentapiid, vbsubscriptionid, vbsubscription_subid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_17()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'paymentapi_remote_orderid'),
			"
			CREATE TABLE " . TABLE_PREFIX . "paymentapi_remote_orderid (
				paymentapiid INT UNSIGNED NOT NULL DEFAULT 0,
				hash VARCHAR(32) NOT NULL DEFAULT '',
				remoteorderid VARCHAR(150) NOT NULL DEFAULT '',
				recurring SMALLINT UNSIGNED NOT NULL DEFAULT '0',
				PRIMARY KEY (remoteorderid, paymentapiid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_18()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'paymentapi_remote_invoice_map'),
			"
			CREATE TABLE " . TABLE_PREFIX . "paymentapi_remote_invoice_map (
				paymentapiid INT UNSIGNED NOT NULL DEFAULT 0,
				remotesubscriptionid VARCHAR(150) NOT NULL DEFAULT '',
				hash VARCHAR(32) NOT NULL DEFAULT '',
				INDEX invoice_map(paymentapiid, remotesubscriptionid, hash)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
