<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_570a3 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$db = vB::getDbAssertor();
		$fieldname = 'pagemeta';
		$existing = $db->getRow('phrasetype', ['fieldname' => $fieldname]);
		if (!$existing)
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'phrasetype'));
			$db->insert('phrasetype', [
				'fieldname' => $fieldname,
				'title' => $this->phrase['phrasetype'][$fieldname] ?? $fieldname,
				'editrows' => 3,
				'special' => 1,
			]);
		}
		else
		{
			$this->skip_message();
		}
	}

	// Add Stripe payment API
	public function step_2()
	{
		$assertor = vB::getDbAssertor();
		if (!$assertor->getRow('vBForum:paymentapi', ['classname' => 'stripe']))
		{
			$assertor->insert('vBForum:paymentapi', [
				'title'     => 'Stripe',
				'currency'  => 'usd,gbp,eur,aud,cad',
				'recurring' => 1,
				'classname' => 'stripe',
				'active'    => 0,
				'settings'  => serialize([
					'public_key' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'secret_key' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'webhook_id' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'webhook_secret' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
				]),
				'subsettings' => serialize([
					'show' => [
						'type' => 'yesno',
						'value' => 1,
						'validate' => 'boolean'
					],
					'tax' => [
						'type' => 'yesno',
						'value' => 0,
						'validate' => 'boolean'
					],
					'tax_category' => [
						'type' => 'text',
						'value' => '',
						'validate' => 'string'
					],
					'tax_behavior' => [
						'type' => 'select',
						'options' => ['inclusive', 'exclusive'],
						'value' => 'inclusive',
						'validate' => 'string'
					],
				]),
			]);
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'paymentapi', 2, 2));
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_3()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'paymentapi_subscription'),
			"
			CREATE TABLE " . TABLE_PREFIX . "paymentapi_subscription (
				paymentapiid INT UNSIGNED NOT NULL DEFAULT 0,
				vbsubscriptionid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				userid INT UNSIGNED NOT NULL DEFAULT 0,
				paymentsubid VARCHAR(150) NOT NULL DEFAULT '',
				active SMALLINT NOT NULL DEFAULT 1,
				PRIMARY KEY (paymentapiid, vbsubscriptionid, userid, paymentsubid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
