<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_570a2 extends vB_Upgrade_Version
{
	// Add Sandbox toggle for PayPal
	public function step_1()
	{
		$assertor = vB::getDbAssertor();
		$paypalAPIs = $assertor->getRows('vBForum:paymentapi', ['classname' => 'paypal']);
		if (empty($paypalAPIs))
		{
			$this->skip_message();
			return;
		}
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'paymentapi', 1, 2));
		$processed = false;
		foreach ($paypalAPIs AS $__paypal)
		{
			$settings = vB_Utility_Unserialize::unserialize($__paypal['settings']);
			if (!isset($settings['sandbox']))
			{
				$processed = true;
				$settings['sandbox'] = [
					'type' => 'yesno',
					'value' => 0,
					'validate' => 'boolean'
				];
				$assertor->update('vBForum:paymentapi', ['settings' => serialize($settings)], ['paymentapiid' => $__paypal['paymentapiid']]);
			}
		}

		if (!$processed)
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
