<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_567a4 extends vB_Upgrade_Version
{
	private $userFieldCount = 19;

	public function step_1()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitFacebook');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 1, $this->userFieldCount));
			$db->assertQuery('vBInstall:alterIndexLimitFacebook');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'user', 191));
		}
	}

	public function step_2()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 2, $this->userFieldCount),
			'user',
			'membergroupids',
			'varchar',
			[
				'length' => 250,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_3()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 3, $this->userFieldCount),
			'user',
			'email',
			'varchar',
			[
				'length' => 100,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_4()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 4, $this->userFieldCount),
			'user',
			'parentemail',
			'varchar',
			[
				'length' => 100,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_5()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 5, $this->userFieldCount),
			'user',
			'homepage',
			'varchar',
			[
				'length' => 100,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_6()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 6, $this->userFieldCount),
			'user',
			'usertitle',
			'varchar',
			[
				'length' => 250,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_7()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 7, $this->userFieldCount),
			'user',
			'icq',
			'varchar',
			[
				'length' => 20,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}


	public function step_8()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 8, $this->userFieldCount),
			'user',
			'yahoo',
			'varchar',
			[
				'length' => 32,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_9()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 9, $this->userFieldCount),
			'user',
			'skype',
			'varchar',
			[
				'length' => 32,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}


	public function step_10()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 10, $this->userFieldCount),
			'user',
			'google',
			'varchar',
			[
				'length' => 32,
				'attributes' => self::FIELD_DEFAULTS
			]
		);
	}

	public function step_11()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 11, $this->userFieldCount),
			'user',
			'assetposthash'
		);
	}

	public function step_12()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 12, $this->userFieldCount),
			'user',
			'msn'
		);
	}

	public function step_13()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 13, $this->userFieldCount),
			'user',
			'aim'
		);
	}

	public function step_14()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 14, $this->userFieldCount),
			'user',
			'gmmoderatedcount'
		);
	}

	public function step_15()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 15, $this->userFieldCount),
			'user',
			'pmpopup'
		);
	}

	public function step_16()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 16, $this->userFieldCount),
			'user',
			'socgroupinvitecount'
		);
	}

	public function step_17()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 17, $this->userFieldCount),
			'user',
			'socgroupreqcount'
		);
	}

	public function step_18()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 18, $this->userFieldCount),
			'user',
			'pcunreadcount'
		);
	}

	public function step_19()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 19, $this->userFieldCount),
			'user',
			'pcmoderatedcount'
		);
	}

	public function step_20()
	{
		$mapper = new vB_Stylevar_Mapper();

		// Changing a Color to Border type
		$mapper->addMapping('profile_content_divider_border.color', 'profile_content_divider_border.color');

		// Do the processing
		if ($mapper->load() AND $mapper->process())
		{
			$this->show_message($this->phrase['core']['mapping_customized_stylevars']);
			$mapper->processResults();
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
