<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_566a5 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->long_next_step();
	}

	public function step_2()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 3),
			'user',
			'displayname',
			'VARCHAR',
			[
				'length'  => 191,
				'null'    => false,
				'default' => '',
			]
		);
		$this->long_next_step();
	}

	public function step_3()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 2, 3),
			'user',
			'displayname',
			['displayname', ]
		);
		$this->long_next_step();
	}

	public function step_4($data)
	{
		if ($this->field_exists('user', 'displayname'))
		{
			// Avoid rerunning this if we already ran it at least once (especially as part of 500a1).
			// Note that the copyUnescapedUsernameToDisplayName query itself has a check for displayname = '' built in and will not
			// update those updated, but no sense in scrolling through the user table again if we don't need to.
			// Side note, we may want to add an adminCP tool to re-run the query for user ranges to "bulk reset" user displaynames.
			$check = vB::getDbAssertor()->getRow('user', ['displayname' => '']);
			if (empty($check))
			{
				$this->skip_message();
				return;
			}

			if (empty($data['startat']))
			{
				$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'user', 3, 3));
			}

			$callback = function($startat, $nextid)
			{
				vB::getDbAssertor()->assertQuery('vBInstall:copyUnescapedUsernameToDisplayName', [
					'startat' => $startat,
					'nextid' => $nextid,
				]);
			};

			$batchsize = $this->getBatchSize('large', __FUNCTION__);
			$newdata = $this->updateByIdWalk($data, $batchsize, 'vBInstall:getMaxUserid', 'user', 'userid', $callback);

			return $newdata;
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
