<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_566a2 extends vB_Upgrade_Version
{
	// If using the now removed legacy CLI imagemagick, switch them to GD
	public function step_1()
	{
		vB_Upgrade::createAdminSession();
		$options = vB::getDatastore()->getValue('options');
		if ($options['imagetype'] == 'Magick')
		{
			$this->show_message($this->phrase['version']['566a2']['switching_to_gd']);
			$this->set_option('imagetype', 'attachment', 'GD');
			$this->add_adminmessage(
				'after_upgrade_legacy_magick_disabled',
				array(
					'dismissible' => 1,
					'execurl'     => 'options.php?do=options&dogroup=attachment',
					'method'      => 'get',
					'status'      => 'undone',
				)
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		vB_Upgrade::createAdminSession();
		$options = vB::getDatastore()->getValue('options');
		if ($options['regimagetype'] == 'Magick')
		{
			$this->show_message($this->phrase['version']['566a2']['switching_to_gd_hv']);
			// I don't know why this is named GDttf instead of GD even though the default value for this
			// setting is GD. But the option displayed in verify.php is GDttf and not GD, and while I think
			// setting it to GD actually works (both will default to GD), it doesn't look great.
			// Going with the apparently canonical value.
			$this->set_option('regimagetype', 'attachment', 'GDttf');
			$this->add_adminmessage(
				'after_upgrade_legacy_magick_disabled_hv',
				array(
					'dismissible' => 1,
					'execurl'     => 'verify.php',
					'method'      => 'get',
					'status'      => 'undone',
				)
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
