<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_566a1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetdefinition'));
		vB::getDbAssertor()->assertQuery('vBInstall:deleteOrphanedWidgetDefintions');
	}

	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'setting'));
		$db  = vB::getDbAssertor();

		//Renaming an existing setting is *surprisingly* hard.  The issue is that there are several cases
		//1) Neither setting exists because we're upgrading from before it was created
		//2) The old setting exists because we're upgrading from after.
		//3) Only the new setting exists because we hit a step that loads the settings (but didn't have the old one)
		//4) We have both because we had the old setting and hit a step that loads the settings.
		//
		//Not all of these are possible for any given setting but trying to figure out what's possible and what
		//isn't based on exactly which versions of vbulletin this site got upgraded to (as opposed to "passing through"
		//a the versions without running final/reimporting the settings) is a mug's game.
		//
		//Mostly we want to preserve the value that the user may have set.  The rest is meta data controlled by the XML
		//and we want to have as light of a touch as possible.  So we'll do the following
		//1) If the new setting doesn't exist then move the old setting to be the new setting.  Implicitly we'll
		//	do nothing if we don't have either (nothing to do there)
		//2) If we have both, copy the old value to the new
		//3) If we only have the new, assume it's correct and go on with life, nothing to do.
		//
		//Note that this only handles the values.  We'll rely on the setting reimport to handle any other changes (we
		//don't want to attempt to preserve that anyway).  We also constantly rebuild the setting datastore after every
		//step and there isn't much point to doing it explicitly a second time.
		//
		//I couldn't find anywhere else where we've done this in the upgrade but if we have to do it again it might
		//be worth breaking this into a utility function.
		$column = $db->getColumn('setting', 'varname', ['varname' => 'trendingminimum']);
		if (!$column)
		{
			$db->update('setting', ['varname' => 'trendingminimum'], ['varname' => 'trendingminium']);
		}
		else
		{
			$db->assertQuery('vBInstall:copyOldOptionValue', [
				'oldvarname' => 'trendingminium',
				'newvarname' => 'trendingminimum',
			]);
		}
	}

}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision$
|| ####################################################################
\*======================================================================*/
