<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_565a8 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->long_next_step();
	}

	public function step_2()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 1, 5),
			'node',
			'hasanswer',
			'TINYINT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
		$this->long_next_step();
	}

	public function step_3()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 2, 5),
			'node',
			'isanswer',
			'TINYINT',
			['null' => false, 'default' => '0']
		);
		$this->long_next_step();
	}

	public function step_4()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 3, 5),
			'node',
			'answer_set_by_user',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
		$this->long_next_step();
	}

	public function step_5()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 4, 5),
			'node',
			'answer_set_time',
			'INT',
			[
				'attributes' => 'UNSIGNED',
				'null'       => false,
				'default'    => 0,
			]
		);
		$this->long_next_step();
	}

	// create nodevote related tables
	public function step_6()
	{
		$this->run_query(
			sprintf($this->phrase['version']['565a8']['adding_nodevote_tables_x_of_y'], 1, 4),
			"
			CREATE TABLE " . TABLE_PREFIX . "nodevote (
				voteid INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
				nodeid INT UNSIGNED NOT NULL DEFAULT 0,
				userid INT UNSIGNED NOT NULL DEFAULT 0,
				votetypeid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				votegroupid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				whovoted INT UNSIGNED NOT NULL DEFAULT 0,
				dateline INT UNSIGNED NOT NULL DEFAULT 0,
				UNIQUE KEY enforce_single (nodeid, whovoted, votetypeid),
				KEY node_votes (nodeid, votegroupid, whovoted),
				KEY user_votes (userid, votegroupid, whovoted),
				KEY vote_agg_helper (nodeid, votetypeid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_7()
	{
		$this->run_query(
			sprintf($this->phrase['version']['565a8']['adding_nodevote_tables_x_of_y'], 2, 4),
			"
			CREATE TABLE " . TABLE_PREFIX . "nodevotetype (
				votetypeid SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,
				label VARCHAR(191) NOT NULL,
				votegroupid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				PRIMARY KEY (votetypeid),
				UNIQUE KEY (label, votegroupid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_8()
	{
		$this->run_query(
			sprintf($this->phrase['version']['565a8']['adding_nodevote_tables_x_of_y'], 3, 4),
			"
			CREATE TABLE " . TABLE_PREFIX . "nodevotegroup (
				votegroupid SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,
				label VARCHAR(191) NOT NULL UNIQUE,
				onchange ENUM('deny', 'radio', 'checkbox'),
				PRIMARY KEY (votegroupid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_9()
	{
		$this->run_query(
			sprintf($this->phrase['version']['565a8']['adding_nodevote_tables_x_of_y'], 4, 4),
			"
			CREATE TABLE " . TABLE_PREFIX . "nodevoteaggregate (
				nodeid INT UNSIGNED NOT NULL DEFAULT 0,
				votetypeid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
				votes INT UNSIGNED NOT NULL DEFAULT 0,
				PRIMARY KEY (nodeid, votetypeid)
			) ENGINE = " . $this->hightrafficengine . "
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_10()
	{
		$this->show_message($this->phrase['core']['cache_update']);
		// mainly just a utility for a/b testers since some of the internal cached data has changed.
		// force rebuild of cached nodevotes datastore items just to be safe.
		vB_Library::instance('nodevote')->reloadNodevoteMetaDataFromDB();
		$this->long_next_step();
	}

	public function step_11()
	{
		// Fix any alpha data generated while we had the `node`.`answerid` column
		if ($this->field_exists('node', 'answerid') AND $this->field_exists('node', 'hasanswer'))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'node'));
			vB::getDbAssertor()->assertQuery('vBInstall:565a8_moveAnsweridToHasanswer');
		}
		else
		{
			$this->skip_message();
		}
		$this->long_next_step();
	}

	public function step_12()
	{
		// Remove the replaced answerid field if exists. This field was added then removed in Alpha 8
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 5, 5),
			'node',
			'answerid'
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112173 $
|| ####################################################################
\*======================================================================*/
