<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_565a6 extends vB_Upgrade_Version
{
	/**
	* Ending version compatibility
	*
	* @var	string
	*/
	public $VERSION_COMPAT_ENDS = '';

	public function step_1()
	{
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		/*
		TODO runonce update allowedbbcodes to
		allowedbbcodes | 8192 | 1024 to enable img & video bbcodes by default (current behavior)
		 */
		$this->show_message($this->phrase['version']['565a6']['enabling_img_video_bbcodes']);

		$assertor = vB::getDbAssertor();
		$row = $assertor->getRow('setting', ['varname' => 'allowedbbcodes']);
		$row['value'] = $row['value'] |
						vB_Api_Bbcode::ALLOW_BBCODE_IMG |
						vB_Api_Bbcode::ALLOW_BBCODE_VIDEO;
		$assertor->update('setting',
			['value'     => $row['value'], ], // values
			['varname' => $row['varname'], ]  // condition
		);
	}

	public function step_2()
	{
		// Place holder to allow iRan() to work properly for CLI upgrade.
		$this->skip_message();
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112173 $
|| ####################################################################
\*======================================================================*/
