<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_564a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$db = vB::getDbAssertor();

		$guid = 'vbulletin-widget_15-4eb423cfd6bd63.20171439';
		$oldWidget = $db->getRow('widget', ['guid' => $guid]);

		if ($oldWidget)
		{
			// delete the old widget & widget definition records
			$db->delete('widgetinstance', ['widgetid' => $oldWidget['widgetid']]);
			$db->delete('widgetdefinition', ['widgetid' => $oldWidget['widgetid']]);
			$db->delete('widget', ['widgetid' => $oldWidget['widgetid']]);
			$this->show_message($this->phrase['version']['564a2']['remove_php_widget']);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'usertextfield', 1, 1),
			'usertextfield',
			'status',
			'MEDIUMTEXT',
			self::FIELD_DEFAULTS
		);
	}
	public function step_3($data)
	{
		if ($this->field_exists('user', 'status'))
		{
			if (empty($data['startat']))
			{
				$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'user', 1, 1));
			}

			$callback = function($startat, $nextid)
			{
				$db = vB::getDbAssertor();
				$db->assertQuery('vBInstall:updateUserStatus', ['startat' => $startat, 'nextid' => $nextid]);
			};

			$batchsize = $this->getBatchSize('large', __FUNCTION__);
			return $this->updateByIdWalk($data, $batchsize, 'vBInstall:getMaxUserid', 'user', 'userid', $callback);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_4()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 1, 1),
			'user',
			'status'
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
