<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_562a3 extends vB_Upgrade_Version
{
	public function step_1()
	{
		// We're just changing any logip == 2 to 1, and that doesn't
		// require the new setting import first.

		vB_Upgrade::createAdminSession();
		$assertor = vB::getDbAssertor();
		$options = vB::getDatastore()->getValue('options');
		if ($options['logip'] == 2)
		{
			$this->set_option('logip', '', 1);
			$this->show_message($this->phrase['version']['562a3']['updating_logip']);
			$this->add_adminmessage(
				'after_upgrade_logip_changed',
				array(
					'dismissible' => 1,
					'execurl'     => 'options.php?do=options&dogroup=posting#logip',
					'method'      => 'get',
					'status'      => 'undone',
				)
			);

		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		vB_Upgrade::createAdminSession();

		$library = vB_Library::instance('options');

		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'location', 1, 1));
		$allusers = array(
			'title' => 'All Users',
			'locationcodes' => array('ALLUSERS'),
		);
		$library->saveLocation($allusers);
	}

}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112173 $
|| ####################################################################
\*======================================================================*/
