<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_556a4 extends vB_Upgrade_Version
{
	/**
	 * Handle customized values (in custom styles) for stylevars that have been renamed
	 */
	public function step_1()
	{
		$mapper = new vB_Stylevar_Mapper();

		// Map the entire stylevar value from old to new since this is only a rename
		// No need for mapping of any of the stylevar parts or any presets, since
		// we only renamed the stylevar and didn't change the data type.
		$mapper->addMapping('icon_size_forum_icon', 'forum_icon_size');

		// Do the processing
		if ($mapper->load() AND $mapper->process())
		{
			$this->show_message($this->phrase['core']['mapping_customized_stylevars']);
			$mapper->processResults();
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * Update inheritance for stylevars that inherit from a stylevar that was just renamed
	 */
	public function step_2()
	{
		$mapper = new vB_Stylevar_Mapper();
		$result = $mapper->updateInheritance('icon_size_forum_icon', 'forum_icon_size');

		if ($result)
		{
			$this->show_message($this->phrase['core']['updating_customized_stylevar_inheritance']);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
