<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_556a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'notice', 1, 1),
			'notice',
			'noticeoptions',
			'int',
			self::FIELD_DEFAULTS
		);
	}

	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'));
		$db = vB::getDbAssertor();

		$bitfields = vB::getDatastore()->getValue('bf_misc_announcementoptions');

		$options = 0;
		$options |= $bitfields['allowhtml'];

		$db->update('vBForum:notice', array('noticeoptions' => $options), array('noticeoptions' => 0));
	}

	public function step_3()
	{
		$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'noticecache'));
		vB_Library::instance('notice')->buildNoticeDatastore();
	}

	public function step_4()
	{
		$this->add_field(
			sprintf($this->phrase['vbphrase']['alter_table'], 'profilefield'),
			'profilefield',
			'showonpost',
			'smallint',
			self::FIELD_DEFAULTS
		);
	}

	public function step_5()
	{
		$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'profilefield'));
		vB_Library::instance('user')->buildProfileFieldDatastore();
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
