<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_556a1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		// import vbulletin-settings.xml so "useemoji" exists for step 2
		vB_Library::clearCache();
		$this->final_load_settings();
	}

	public function step_2()
	{
		// See also vB_Upgrade_install::step_5
		$assertor = vB::getDbAssertor();
		$charsets = $assertor->getDbCharsets('text', 'rawtext');
		if ($charsets['effectiveCharset'] == 'utf8mb4')
		{
			$this->show_message($this->phrase['version']['556a1']['enabling_ckeditor_emoji_plugin']);

			vB_Upgrade::createAdminSession();
			// NOTE: set_option requires the option to already exist or else it won't set it.
			$this->set_option('useemoji', '', 1);
		}
		else
		{
			$this->skip_message();
		}
	}


}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
