<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_555a3 extends vB_Upgrade_Version
{
	public function step_1()
	{
		// noop step just to output the long step message
		// for updating the birthdayemail user option
		$this->long_next_step();
	}

	// Set the user 'birthdayemail' option to 'on' for all existing users. There previously
	// was no option and all users would get the email.
	public function step_2()
	{
		$assertor = vB::getDbAssertor();

		// bitfields are rebuilt as part of the upgrade initialization, so the
		// new bitfield will already be present here (see class_upgrade init())
		$bf_misc_useroptions = vB::getDatastore()->getValue('bf_misc_useroptions');

		$check = $assertor->getRow('vBInstall:checkUserOptionBirthdayEmails', array(
			'birthdayemailmask' => $bf_misc_useroptions['birthdayemail'],
		));

		if (!$check)
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'user'));

			// If setting this bit in one go turns out to be too much, we can use
			// updateByIdWalk(). But we allow this type of query in the Admin CP
			// query tool, so I think it will be okay here. Added the 'long next step'
			// message just to be on the safe side.
			$result = $assertor->assertQuery('vBInstall:updateUserOptionBirthdayEmails', array(
				'birthdayemailmask' => $bf_misc_useroptions['birthdayemail'],
			));
		}
		else
		{
			// There is at least one user with the birthday email option turned on, so
			// we'll assume that this step has already run or that v555a3 or later has
			// already been installed. In either case, we don't want to run this step
			// and risk enabling 'birthdayemail' for users who have already turned it
			// off.
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
