<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_555a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->alter_field(
			sprintf($this->phrase['core']['altering_x_table'], 'contentpriority', 1, 1),
			'contentpriority',
			'prioritylevel',
			'double',
			array(
				'length' => '2,1',
			)
		);
	}

	public function step_2()
	{
		$this->show_message($this->phrase['version']['555a2']['remove_product_custom_phrases']);

		/*
			Delete invalid "custom" (languageid = 0) phrases that were added for fresh installs with
			language packs due to step_3() importing the product translation XMLs before step_13() could
			import the product XMLs (that contain the master phrases).

			While it's hypothetically possible that non-vbulletin products might've been affected, I'm
			trying to limit the scope of change to the ones we definitively saw on the affected cloud
			installs.
		 */
		$products = vB_Products::DEFAULT_VBULLETIN_PRODUCTS;
		if (!empty($products))
		{
			$assertor = vB::getDbAssertor();
			$assertor->delete('phrase', array('languageid' => 0, 'product' => $products));
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
