<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_553a4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		/*
			We used to always append node.nodeid ASC sorting to every single search
			query.
			We've changed that to only append it when it's needed (when there's a
			created ASC|DESC sort), and to *match* the direction of the created sorting.
			The same direction allows mysql to use a (created, nodeid) index to sort
			and speed up certain queries.
		 */
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 1, 2),
			'node',
			'created'
		);
		$this->long_next_step();
	}

	public function step_2()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 2, 2),
			'node',
			'created',
			array('created', 'nodeid')
		);
	}

	public function step_3()
	{
		$datastore = vB::getDatastore();
		$defaultchannelpermissions = $datastore->getValue('defaultchannelpermissions');

		$changed = false;
		foreach($defaultchannelpermissions AS $node => $groups)
		{
			foreach($groups AS $group => $permissions)
			{
				foreach($permissions AS $name => $value)
				{
					//this should never be an array but a bug in caused arrays to be created instead of values overwritten
					//no good can come of this.  The last value in the array is the one most likely intended as the correct
					//value so we'll go with that.
					if (is_array($value))
					{
						$changed = true;
						$defaultchannelpermissions[$node][$group][$name] = end($value);
					}
				}
			}
		}

		if ($changed)
		{
			$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'defaultchannelpermissions'));
			$datastore->build('defaultchannelpermissions', serialize($defaultchannelpermissions), 1);
		}
		else
		{
			$this->skip_message();
		}
	}

	// Update the permissions for skip_moderate in 'defaultchannelpermissions'
	public function step_4()
	{
		$datastore = vB::getDatastore();
		$defaultchannelpermissions = $datastore->getValue('defaultchannelpermissions');
		if (empty($defaultchannelpermissions))
		{
			// if this isn't created yet, then there's nothing to do.
			return $this->skip_message();
		}

		if (!is_array($defaultchannelpermissions))
		{
			$defaultchannelpermissions = vB_Utility_Unserialize::unserialize($defaultchannelpermissions);
		}

		$forumpermissions = $datastore->getValue('bf_ugp_forumpermissions2');
		$topicperm = $forumpermissions['skipmoderatetopics'];
		$replyperm = $forumpermissions['skipmoderatereplies'];
		$attachperm = $forumpermissions['skipmoderateattach'];

		$allperms = $topicperm | $replyperm | $attachperm;

		$needsRebuild = false;
		foreach($defaultchannelpermissions AS $__nodekey => $__innerArr)
		{
			foreach ($__innerArr AS $__groupkey => $permissions)
			{
				if (isset($permissions['skip_moderate']))
				{
					$needsRebuild = true;
					if ($permissions['skip_moderate'])
					{
						$defaultchannelpermissions[$__nodekey][$__groupkey]['forumpermissions2'] |= $allperms;
					}
					else
					{
						$defaultchannelpermissions[$__nodekey][$__groupkey]['forumpermissions2'] &= ~$allperms;
					}

					unset($defaultchannelpermissions[$__nodekey][$__groupkey]['skip_moderate']);
				}
			}
		}

		if ($needsRebuild)
		{
			// show message.
			$this->show_message($this->phrase['version']['541b1']['rebuilding_defaultchannelperms_datastore']);
			$datastore->build('defaultchannelpermissions', serialize($defaultchannelpermissions), 1);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
