<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_553a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->drop_table('customprofilepic');
	}

	public function step_2()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'usergroup', 1, 3),
			'usergroup',
			'profilepicmaxwidth'
		);
	}

	public function step_3()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'usergroup', 2, 3),
			'usergroup',
			'profilepicmaxheight'
		);
	}

	public function step_4()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'usergroup', 3, 3),
			'usergroup',
			'profilepicmaxsize'
		);
	}

	public function step_5()
	{
		$db = vB::getDbAssertor();

		$datastore = vB::getDatastore();
		$forumpermissions = $datastore->getValue('bf_ugp_forumpermissions2');
		$topicperm = $forumpermissions['skipmoderatetopics'];
		$replyperm = $forumpermissions['skipmoderatereplies'];
		$attachperm = $forumpermissions['skipmoderateattach'];

		$permissions = $datastore->getValue('bf_ugp_genericoptions');
		$notbannedgroup = $permissions['isnotbannedgroup'];

		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'usergroup'));
		//we don't have skip_moderate for the usergroups -- it's only on the forumpermission record.  It
		//does not appear that we are actually doing anything with the formpermission2 record -- changing
		//it on the user group page actually sets it on the root forum -- so let's set some sensisble defaults
		//that should sync the behavior with new installs and call it a day.

		//set the permissions to true if the group is not banned.
		$db->update('usergroup',
			array(
				vB_dB_Query::BITFIELDS_KEY => array (
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_SET, 'value' => $topicperm),
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_SET, 'value' => $replyperm),
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_SET, 'value' => $attachperm),
				)
			),
			array(array('field' => 'genericoptions', 'operator' => vB_dB_Query::OPERATOR_AND, 'value' => $notbannedgroup))
		);

		//set the permissions to false if the group is banned.
		$db->update('usergroup',
			array(
				vB_dB_Query::BITFIELDS_KEY => array (
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_UNSET, 'value' => $topicperm),
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_UNSET, 'value' => $replyperm),
					array('field' => 'forumpermissions2', 'operator' => vB_dB_Query::BITFIELDS_UNSET, 'value' => $attachperm),
				)
			),
			array(array('field' => 'genericoptions', 'operator' => vB_dB_Query::OPERATOR_NAND, 'value' => $notbannedgroup))
		);
	}

	// Add covering index to support fcm_cron's fetching fcmessage_offload by receiveafter
	public function step_6()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'fcmessage_offload', 1, 1),
			'fcmessage_offload',
			'removeafter_hash',
			array('removeafter', 'hash')
		);
	}

	public function step_7()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 1, 3),
			'user',
			'profilepicrevision'
		);
	}

	public function step_8()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 2, 3),
			'user',
			'logintype'
		);
	}

	public function step_9()
	{
		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], TABLE_PREFIX . 'user', 3, 3),
			'user',
			'fbaccesstoken'
		);
	}

	/**
	 * Update user.startofweek to 1 (Sunday), if they currently have -1 (an invalid value)
	 */
	public function step_10($data = null)
	{
		if (empty($data['startat']))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'user', 1, 1));
		}

		$filter = ['startofweek' => -1];

		$walker = new vB_UpdateTableWalker(vB::getDBAssertor());
		$walker->setBatchSize($this->getBatchSize('small', __FUNCTION__));
		$walker->setMaxQuery('vBinstall:getMaxUserid');
		$walker->setNextidQuery('user', 'userid', $filter);
		$walker->setCallbackUpdateTable(['startofweek' => 1], $filter);

		return $this->updateByWalker($walker, $data);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
