<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_550a1 extends vB_Upgrade_Version
{
	// Update orphan `reportnodeid` references for reports pointing to deleted nodes
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'report', 1, 1));

		$db = vB::getDbAssertor();
		$db->assertQuery('vBInstall:updateOrphanReports');

		$this->long_next_step();
	}

	// Remove unused `text`.`reportnodeid`
	public function step_2()
	{
		vB_Upgrade::createAdminSession();
		$assertor = vB::getDbAssertor();

		if ($this->field_exists('text', 'reportnodeid'))
	{
			$this->run_query(
				sprintf($this->phrase['core']['altering_x_table'], 'text', 1, 1),
				"ALTER TABLE " . TABLE_PREFIX . "text
					DROP COLUMN reportnodeid"
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112174 $
|| ####################################################################
\*======================================================================*/
