<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_544a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->updateHeaderUrls(array(
			'blogadmin/create' => 'blogadmin/create/settings',
			'sgadmin/create' => 'sgadmin/create/settings'
		));
	}

	public function step_2()
	{
		//update the pages so they point back to the routes that point at them.  This managed to get out of
		//sync due to some previous bugs.  Don't update redirect routes -- we never want a page to point to
		//a redirect route.
		$db = vB::getDbAssertor();
		$routes = $db->select('routenew', array(array('field' => 'redirect301', 'operator' => vB_dB_Query::OPERATOR_ISNULL)));
		foreach($routes AS $route)
		{
			$args = unserialize($route['arguments']);
			if (!empty($args['pageid']))
			{
				//we should always have a page, but if we don't we aren't going to try to correct that here.
				$page = $db->getRow('page', array('pageid' => $args['pageid']));
				if ($page AND ($page['routeid'] != $route['routeid']))
				{
					$db->update('page', array('routeid' => $route['routeid']), array('pageid' => $page['pageid']));
				}
			}
		}
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'));
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
