<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_542a4 extends vB_Upgrade_Version
{
	/*
	 * Pickup product XML changes in alpha 4 (moved from alpha 3)
	 */
	public function step_1()
	{
		// Packages are installed/upgraded as part of upgrade_final step_13
		$this->skip_message();
	}

	/*
	 *	Fix channel route REs so that they work with and without a prefix without modification.
	 */
	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'));

		$db = vB::getDBAssertor();
		$set = $db->select('routenew', array('class' => 'vB5_Route_Channel'));
		foreach($set AS $row)
		{
			//we have a difference based on whether or nto the prefix is blank
			//(to account for the fact that we only have a slash before the page if
			//we have
			$expected = ($row['prefix'] === '' ? '(?:page(' : '(?:/page(');
			$newre = str_replace($expected, '(?:(?:/|^)page(', $row['regex']);
			$row = $db->update('routenew', array('regex' => $newre), array('routeid' => $row['routeid']));
		}
	}

	public function step_3()
	{
		$this->drop_table('bookmarksite');
	}

	public function step_4()
	{
		vB::getDatastore()->delete('bookmarksitecache');
		$this->show_message(sprintf($this->phrase['core']['remove_datastore_x'], 'bookmarksitecache'));
	}

	public function step_5()
	{
		$this->drop_table('indexqueue');
	}

	public function step_6()
	{
		$this->drop_table('discussionread');
	}

	public function step_7()
	{
		$this->drop_table('picturelegacy');
	}

	public function step_8()
	{
		$this->drop_table('podcast');
	}

	public function step_9()
	{
		$this->drop_table('podcastitem');
	}

}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112175 $
|| ####################################################################
\*======================================================================*/
