<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_541b1 extends vB_Upgrade_Version
{
	// Reinstall twitterlogin package step moved to 541b2.
	public function step_1()
	{
		$this->skip_message();
	}


	// Replace require_moderate with skip_moderate in 'defaultchannelpermissions'
	// See VBV-18294
	public function step_2()
	{
		$datastore = vB::getDatastore();
		$datastore->fetch('defaultchannelpermissions');
		$defaultchannelpermissions = vB::getDatastore()->getValue('defaultchannelpermissions');
		if (empty($defaultchannelpermissions))
		{
			// if this isn't created yet, then there's nothing to do.
			return $this->skip_message();
		}

		if (!is_array($defaultchannelpermissions))
		{
			$defaultchannelpermissions = vB_Utility_Unserialize::unserialize($defaultchannelpermissions);
		}

		$needsRebuild = false;
		foreach($defaultchannelpermissions AS $__nodekey => $__innerArr)
		{
			foreach ($__innerArr AS $__groupkey => $permissions)
			{
				if (isset($permissions['require_moderate']))
				{
					$needsRebuild = true;
					$defaultchannelpermissions[$__nodekey][$__groupkey]['skip_moderate'] = !($permissions['require_moderate']);
					unset($defaultchannelpermissions[$__nodekey][$__groupkey]['require_moderate']);
				}
			}
		}

		if ($needsRebuild)
		{
			// show message.
			$this->show_message($this->phrase['version']['541b1']['rebuilding_defaultchannelperms_datastore']);
			$datastore->build('defaultchannelpermissions', serialize($defaultchannelpermissions), 1);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112175 $
|| ####################################################################
\*======================================================================*/
