<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_540a1 extends vB_Upgrade_Version
{
	/**
	 * Update the imgdir_spriteiconsvb stylevar
	 */
	public function step_1()
	{
		vB_Upgrade::createAdminSession();
		$assertor = vB::getDbAssertor();
		$updated = false;

		// Get imgdir_spriteiconsvb stylevar for all styles
		$stylevars = $assertor->getRows('stylevar', array('stylevarid' => 'imgdir_spriteiconsvb'));
		foreach ($stylevars AS $stylevar)
		{
			$unserialized = @unserialize($stylevar['value']);
			if ($unserialized AND is_array($unserialized))
			{
				// if it contains the previous default value, let's set it to blank
				// This stylevar is no longer used by the master/default style, but
				// we'll keep it around for custom styles that may use it.
				if ($unserialized['path'] == 'images/css')
				{
					$unserialized['path'] = '';
					$serialized = serialize($unserialized);
					$assertor->update('stylevar', array('value' => $serialized), array('stylevarid' => $stylevar['stylevarid'], 'styleid' => $stylevar['styleid']));
					$this->show_message(sprintf($this->phrase['version']['540a1']['updating_imgdir_spriteiconsvb_stylevar_in_styleid_x'], $stylevar['styleid']));
					$updated = true;
				}
			}
		}

		if (!$updated)
		{
			$this->skip_message();
		}
	}

	// Add admin message to warn about Groups channel permissions (VBV-17996)
	public function step_2()
	{
		$this->add_adminmessage(
			'after_upgrade_check_groups_channel_permissions',
			array(
				'dismissible' => 1,
				'execurl'     => 'forumpermission.php?do=modify',
				'method'      => 'get',
				'status'      => 'undone',
			)
		);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112175 $
|| ####################################################################
\*======================================================================*/
