<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_535a1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$code = vB::getDatastore()->getOption('ga_code');
		if ($code AND !preg_match('#^\s*<script#', $code))
		{
			$code = '<script type="text/javascript">' . "\n$code\n" . '</script>';
			vB_Library::instance('options')->updateValue('ga_code', $code);
		}
		$this->show_message($this->phrase['version']['535a1']['update_google_analytics']);
	}

	/**
	 * Removing Search Queue Processor Scheduled Tasks
	 */
	public function step_2()
	{
		//it turns out this got a different varname if it was added by the upgrader than if it was
		//added by the installer.  We got one a long time ago, we need to get the other one now.
		$this->show_message(sprintf($this->phrase['version']['503a3']['delete_queue_processor_cron']));
		vB::getDbAssertor()->delete('cron', array(
			'varname' => 'queueprocessor',
			'volatile' => 1,
			'product' => 'vbulletin',
		));
	}

	public function step_3($data)
	{
		if (empty($data['startat']))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'user', 1, 1));
		}

		$callback =	function($startat, $nextid)
		{
			$db = vB::getDbAssertor();
			$db->update(
				'user',
				['maxposts' => -1],
				[
					'maxposts' => 0,
					['field' => 'userid', 'value' => $startat, 'operator' =>  vB_dB_Query::OPERATOR_GTE],
					['field' => 'userid', 'value' => $nextid, 'operator' =>  vB_dB_Query::OPERATOR_LT],
				]
			);
		};

		$batchsize = $this->getBatchSize('large', __FUNCTION__);
		return $this->updateByIdWalk($data, $batchsize, 'vBInstall:getMaxUserid', 'user', 'userid', $callback);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112176 $
|| ####################################################################
\*======================================================================*/
