<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_533b1 extends vB_Upgrade_Version
{
	public function step_1($data = [])
	{

		$assertor = vB::getDbAssertor();
		$batchsize = 500000;
		$startat = intval($data['startat'] ?? 0);

		// output what we're doing -- but only on the first iteration
		if ($startat == 0)
		{
			$this->show_message($this->phrase['version']['510a8']['fixing_imported_polls']);
		}

		//First see if we need to do something. Maybe we're O.K.
		if (!empty($data['maxToFix']))
		{
			$maxToFix = $data['maxToFix'];
		}
		else
		{
			$maxToFix = $assertor->getRow('vBInstall:getMaxPollNodeid', array());
			$maxToFix = intval($maxToFix['maxToFix']);
			//If we don't have any we're done.
			if (intval($maxToFix) < 1)
			{
				$this->skip_message();
				return;
			}
		}

		if ($startat >= $maxToFix)
		{
			$this->show_message(sprintf($this->phrase['core']['process_done']));
			return;
		}

		// Get the poll data, nodeid of the starter, nodeid of the poll and the options from poll table
		$pollData = $assertor->assertQuery('vBInstall:pollFixPollVote',
			array(
				'startat' => $startat,
				'batchsize' => $batchsize,
			)
		);

		$processed = min($startat + $batchsize, $maxToFix);

		$this->show_message(sprintf($this->phrase['core']['processed_records_x_y_z'], $startat + 1, $processed, $maxToFix));
		return array('startat' => ($startat + $batchsize), 'maxToFix' => $maxToFix);
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112176 $
|| ####################################################################
\*======================================================================*/
