<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_533a1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->add_index(
			sprintf($this->phrase['core']['create_index_x_on_y'], 'infractednodeid', TABLE_PREFIX . 'infraction'),
			'infraction',
			'infractednodeid',
			array('infractednodeid')
		);
	}

	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'infraction', 1, 1));

		$db = vB::getDbAssertor();
		$db->assertQuery('vBInstall:updateOrphanInfractions');
	}

	public function step_3()
	{
		$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'channel', 1, 1));

		$db = vB::getDbAssertor();

		$nodeids = $db->getColumn('vBForum:channel', 'nodeid', array('guid' => array('vbulletin-4ecbdf567f3341.44451100', 'vbulletin-4ecbdf567f3a38.99555308')));

		if ($nodeids)
		{
			$db->update('vBForum:node', array('protected' => 1), array('nodeid' => $nodeids));
		}

		$this->long_next_step();
	}

	public function step_4()
	{
		$this->add_index(
			sprintf($this->phrase['core']['create_index_x_on_y'], 'showpublished', TABLE_PREFIX . 'node'),
			'node',
			'showpublished',
			['showpublished']
		);
	}

	/*
	 * Prep for step_6: Need to import the settings XML in case this install doesn't have the new option yet.
	 */
	public function step_5()
	{
		vB_Library::clearCache();
		$this->final_load_settings();
	}

	// If using imagick, check ghostscript & enable or disable imagick_pdf_thumbnail option.
	public function step_6()
	{
		vB_Upgrade::createAdminSession();
		$options = vB::getDatastore()->getValue('options');
		if ($options['imagetype'] == 'Magick')
		{
			if (isset($options['imagick_pdf_thumbnail']))
			{
				$this->show_message($this->phrase['version']['533a1']['checking_ghostscript']);
				$pdfSupported = vB_Image::instance()->canThumbnailPdf();
				$this->set_option('imagick_pdf_thumbnail', 'attachment', $pdfSupported);
				if (!$pdfSupported)
				{
					$this->add_adminmessage(
						'after_upgrade_imagick_pdf_disabled',
						[
							'dismissible' => 1,
							'execurl'     => 'options.php?do=options&dogroup=attachment',
							'method'      => 'get',
							'status'      => 'undone',
						]
					);
				}
			}
			else
			{
				$this->skip_message();
			}
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112176 $
|| ####################################################################
\*======================================================================*/
