<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_530b2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$assertor = vB::getDbAssertor();
		$row = $assertor->getRow('routenew', array('name' => 'settings'));

		//correct the name of the tab for account security
		if (strpos($row['regex'], '|mfa') !== false)
		{
			//handle the possibility that somebody ran the previous upgrade
			//both before and after we changed the name
			if (strpos($row['regex'], '|security') === false)
			{
				$regex = str_replace('|mfa', '|security', $row['regex']);
			}
			else
			{
				$regex = str_replace('|mfa', '', $row['regex']);
			}

			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'));
			$assertor->assertQuery('routenew',
				array(
					vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_UPDATE,
					vB_dB_Query::CONDITIONS_KEY => array('routeid' => $row['routeid']),
					'regex' => $regex
				)
			);
		}
		else
		{
			// we're okay.
			$this->skip_message();
			return;
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112176 $
|| ####################################################################
\*======================================================================*/
