<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_526a3 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->skip_message();
	}

	public function step_2($data = NULL)
	{
		$db = vB::getDbAssertor();
		$batchsize = 1000;

		$startat = (empty($data['startat']) ? 0 : $data['startat']);

		$this->show_message(sprintf($this->phrase['version']['526a3']['deleting_orphaned_tag_associations_x'], $startat), true);

		$nodeids = $db->getColumn('vBInstall:getOrphanedTagAssociations', 'nodeid',
			array('startatnodeid' => 'startat', 'batchsize' => $batchsize)
		);

		//putting distinct in the query causes mysql to do a sort.  Which interacts
		//badly with doing the limit on what could be a fairly expensive query to
		//run to completion.
		$nodeids = array_unique($nodeids);

		if (!$nodeids)
		{
			$this->show_message(sprintf($this->phrase['core']['process_done']));
			return;
		}

		$db->delete('vBForum:tagnode', array('nodeid' => $nodeids));

		return array('startat' => end($nodeids));
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
