<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_526a1 extends vB_Upgrade_Version
{
	/**
	 * Import default pagetemplate.screenlayoutsectiondata values if needed
	 */
	public function step_1()
	{
		vB_Upgrade::createSession();
		$assertor = vB::getDbAssertor();

		$addSectionData = false;
		$guids = array(
			// Some, but not all, of the default page templates that use the wide-narrow
			// screenlayout, specifically, the blog and group pages.
			'vbulletin-4ecbdac93742a5.43676030', // Individual Blog Page Template
			'vbulletin-sgroups93742a5.43676038', // Individual Group Page Template
		);
		$pagetemplates = $assertor->assertQuery('pagetemplate', array(
			'guid' => $guids,
		));
		foreach ($pagetemplates AS $pagetemplate)
		{
			if (empty($pagetemplate['screenlayoutsectiondata']))
			{
				$addSectionData = true;
				break;
			}
		}

		if ($addSectionData)
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['importing_file'], 'vbulletin-pagetemplates.xml'));

			$pageTemplateFile = DIR . '/install/vbulletin-pagetemplates.xml';
			if (!($xml = file_read($pageTemplateFile)))
			{
				$this->add_error(sprintf($this->phrase['vbphrase']['file_not_found'], 'vbulletin-pagetemplates.xml'), self::PHP_TRIGGER_ERROR, true);
				return;
			}

			$options = vB_Xml_Import::OPTION_OVERWRITECOLUMN;
			$xml_importer = new vB_Xml_Import_PageTemplate('vbulletin', $options);
			$xml_importer->setOverwriteColumn('screenlayoutsectiondata');
			$xml_importer->importFromFile($pageTemplateFile, $guids);
			$this->show_message($this->phrase['core']['import_done']);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
