<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_525a1 extends vB_Upgrade_Version
{
	/*
	 * Enable user.options[134217728] by default. Run once only.
	 */
	public function step_1($data = null)
	{
		// Only run once.
		if (empty($data['startat']) AND $this->iRan(__FUNCTION__))
		{
			return;
		}
		elseif (empty($data['startat']))
		{
			$this->show_message($this->phrase['version']['525a1']['setting_user_vbmessenger']);
			$data['startat'] = 0;
		}

		$startat = $data['startat'];
		$batchsize = 5000;

		$max = vB::getDbAssertor()->getRow('vBInstall:getMaxUserid');
		$maxid = $max['maxid'];
		if ($maxid <= $startat)
		{
			$this->show_message(sprintf($this->phrase['core']['process_done']));
			return;
		}


		$count = vB::getDbAssertor()->assertQuery('vBInstall:setUserPmchatOption', array('startat' => $startat, 'batchsize' => $batchsize));
		$this->show_message(sprintf($this->phrase['core']['processed_x_records_starting_at_y'], $count, $startat + 1));

		$data['startat'] = $startat + $batchsize;
		return $data;
	}

	public function step_2()
	{
		// Place holder to allow iRan() to work properly, as the last step gets recorded as step '0' in the upgrade log for CLI upgrade.
		$this->skip_message();
		return;
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
