<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_524a4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->drop_table('subscribegroup');
	}

	// add missing css units
	public function step_2()
	{
		if ($this->field_exists('stylevardfn', 'units'))
		{
			$this->run_query(
				sprintf($this->phrase['core']['altering_x_table'], 'stylevardfn', 1, 1),
				"
					ALTER TABLE " . TABLE_PREFIX . "stylevardfn
					MODIFY COLUMN units
						ENUM('','%','px','pt','em','rem','ch','ex','pc','in','cm','mm','vw','vh','vmin','vmax')
						NOT NULL DEFAULT ''
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/*
	 * Prep for step_4: Need to import the settings XML in case this install doesn't have the new option yet.
	 */
	public function step_3()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		vB_Library::clearCache();
		$this->final_load_settings();
	}

	/*
	 * Copy current floodchecktime value into pm_floodchecktime. Run once only.
	 */
	public function step_4()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}

		vB_Upgrade::createAdminSession();
		$this->show_message($this->phrase['version']['524a4']['copying_floodchecktime']);
		$options = vB::get_datastore()->get_value('options');
		if (isset($options['floodchecktime']) AND isset($options['pm_floodchecktime']))
		{
			$this->set_option('pm_floodchecktime', 'pm', intval($options['floodchecktime']));
		}
	}

	public function step_5()
	{
		// Place holder to allow iRan() to work properly, as the last step gets recorded as step '0' in the upgrade log for CLI upgrade.
		$this->skip_message();
		return;
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
