<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_523a3 extends vB_Upgrade_Version
{
	public function step_1($data = null)
	{
		//would like to do it as a single update query but can't do a
		//limit with a multi-table update and can't use a subquery in an
		//update involving the table you are updating.  So we do it the
		//hard/slow way
		$db = vB::getDbAssertor();
		$batchsize = $this->getBatchSize('xxxsmall', __FUNCTION__);
		$result = $db->assertQuery('vBInstall:selectShowOpenMismatch', ['limit' => $batchsize]);
		$nodes = array();
		foreach($result AS $row)
		{
			$nodes[] = $row['nodeid'];
		}

		if (empty($data['startat']))
		{
			$data['startat'] = 0;
			$this->show_message($this->phrase['version']['523a3']['fix_showopen']);
		}

		$count = count($nodes);
		if ($count)
		{
			$db->update('vBForum:node', ['showopen' => 0], ['nodeid' => $nodes]);

			$this->show_message(sprintf($this->phrase['core']['processing_records_x'], $count));
			// This is just to indicate iteration, the actual value of startat is not used by this method and is not important.
			return ['startat' => 1];
		}
		else
		{
			$this->show_message($this->phrase['core']['process_done']);
			return;
		}
	}

	public function step_2()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitAdcriteria');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'adcriteria', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitAdcriteria');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'adcriteria', 191));
		}
	}

	public function step_3()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitBbcode');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'bbcode', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitBbcode');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'bbcode', 191));
		}
	}

	public function step_4()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitFaq');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'faq', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitFaq');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'faq', 191));
		}
	}

	public function step_5()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitNoticecriteria');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'noticecriteria', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitNoticecriteria');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'noticecriteria', 191));
		}
	}

	public function step_6()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitNotificationevent');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'notificationevent', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitNotificationevent');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'notificationevent', 191));
		}
	}

	public function step_7()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitPhrase');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'phrase', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitPhrase');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'phrase', 191));
		}
	}

	public function step_8()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitStylevar');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'stylevar', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitStylevar');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'stylevar', 191));
		}
	}

	public function step_9()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitUserstylevar');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'userstylevar', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitUserstylevar');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'userstylevar', 191));
		}
	}

	public function step_10()
	{
		$db = vB::getDbAssertor();
		$row = $db->getRow('vBInstall:checkIndexLimitStylevardfn');
		if (!$row)
		{
			$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'stylevardfn', 1, 1));
			$db->assertQuery('vBInstall:alterIndexLimitStylevardfn');
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['523a3']['data_too_long'], 'stylevardfn', 191));
		}
	}

	public function step_11()
	{
		$this->drop_table('profileblockprivacy');
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
