<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_522a5 extends vB_Upgrade_Version
{
	/**
	 * VBV-15926 - Unserialize the show_at_breakpoints module config item
	 */
	public function step_1()
	{
		$db = vB::getDbAssertor();
		$updated = false;

		$instances = $db->select('widgetinstance', [], false,  ['widgetinstanceid', 'adminconfig']);

		foreach ($instances AS $instance)
		{
			if (empty($instance['adminconfig']))
			{
				continue;
			}

			$adminconfig = unserialize($instance['adminconfig']);
			if (!$adminconfig)
			{
				continue;
			}

			if (isset($adminconfig['show_at_breakpoints']))
			{
				if (!is_array($adminconfig['show_at_breakpoints']))
				{
					$unserialized = unserialize($adminconfig['show_at_breakpoints']);
					if ($unserialized)
					{
						$adminconfig['show_at_breakpoints'] = $unserialized;

						$condition = array('widgetinstanceid' => $instance['widgetinstanceid']);
						$values = array('adminconfig' => serialize($adminconfig));
						$db->update('widgetinstance', $values, $condition);

						$updated = true;
					}
				}
			}
		}

		if ($updated)
		{
			$this->show_message($this->phrase['version']['522a5']['update_module_setting_show_at_breakpoints']);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
