<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_522a4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->show_message($this->phrase['version']['522a4']['update_sitemap_directory']);

		$datastore = vB::getDatastore();
		$sitemappath =  $datastore->getOption('sitemap_path');

		//if we currently have an index file, assume that path is absolute or otherwise fine.
		//we check specifically for the file because people not using the sitepath will
		//have the default value and the default directory which should now line up
		if (!resolve_server_path($sitemappath . '/vbulletin_sitemap_index.xml.gz'))
		{
			//attempt to reconstruct the path that would resolve the old way
			if (resolve_server_path('admincp/' . $sitemappath))
			{
				 $datastore->setOption('sitemap_path', 'admincp/' . $sitemappath);
			}
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
