<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_521a6 extends vB_Upgrade_Version
{
	public function step_1()
	{
		//this isn't 100% required because the system will init the admin session
		//for the first step as a side effect, but we should be specific about it
		//in case this changes.  It's also needed for the unit testing.
		vB_Upgrade::createAdminSession();
		$this->show_message($this->phrase['version']['521a6']['rebuild_usergroup_permissions']);
		vB::getUserContext()->rebuildGroupAccess();
	}

	/*
	 * Allow usermentions bbcode by default. Run once only.
	 */
	public function step_2()
	{
		// Only run once.
		if ($this->iRan(__FUNCTION__))
		{
			return;
		}
		$this->show_message($this->phrase['version']['521a6']['enabling_usermention_bbcode']);

		$assertor = vB::getDbAssertor();
		$row = $assertor->getRow('setting', ['varname' => 'allowedbbcodes']);
		$row['value'] |= vB_Api_Bbcode::ALLOW_BBCODE_USER;
		$assertor->update('setting',
			['value' => $row['value']],
			['varname' => $row['varname']]
		);

	}

	public function step_3()
	{
		// Place holder to allow iRan() to work properly, as the last step gets recorded as step '0' in the upgrade log for CLI upgrade.
		$this->skip_message();
		return;

	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
