<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_520a2 extends vB_Upgrade_Version
{
	/*
	 * Step1 : VBV-15341 Unset cansearch for legacy "StaticPage" type
	 */
	public function step_1()
	{
		$assertor = vB::getDbAssertor();

		$package = $assertor->getRow('package', array('class' => 'vBCms'));
		if (empty($package['packageid']))
		{
			// this is not an upgrade from a vb4 DB with vBCms package, nothing to do here.
			return $this->skip_message();
		}

		// Mostly copy pasted from 518a6 (VBV-14770)
		$contenttypes = $assertor->getRows(
			'vBForum:contenttype',
			array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'class',       'value' => array('StaticPage'),	    'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'packageid',   'value' => $package['packageid'],   'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'cansearch',   'value' => 1,                       'operator' =>  vB_dB_Query::OPERATOR_EQ),
				)
			)
		);
		if (empty($contenttypes))
		{
			// Already done. Nothing to do here.
			return $this->skip_message();
		}

		$total = count($contenttypes);
		$i = 0;
		foreach ($contenttypes AS $contenttype)
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'contenttype', ++$i, $total));
			$assertor->update('vBForum:contenttype',
				array(// update values
					'cansearch' => 0,
				),
				array(// update conditions
					'contenttypeid' => $contenttype['contenttypeid']
				)
			);
		}

		// give the cache a kick.
		vB_Types::instance()->reloadTypes();
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112177 $
|| ####################################################################
\*======================================================================*/
