<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_518a6 extends vB_Upgrade_Version
{
	/*
	 * Steps 1 & 2: VBV-14770 - Unset cansearch for the legacy content types that were added for vb4 mapi search reasons.
	 */
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'contenttype', 1, 2));

		$assertor = vB::getDbAssertor();

		// This package was added/verified in 518a2
		$package = $assertor->getRow('package', array('class' => 'vBBlog'));
		$contenttypes = $assertor->getRows(
			'vBForum:contenttype',
			array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'class',		'value' => array('BlogEntry', 'BlogComment'),	'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'packageid',	'value' => $package['packageid'],	'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'cansearch',	'value' => 1, 						'operator' =>  vB_dB_Query::OPERATOR_EQ),
				)
			)
		);
		foreach ($contenttypes AS $contenttype)
		{
			$assertor->update('vBForum:contenttype',
				array(// update values
					'cansearch' => 0,
				),
				array(// update conditions
					'contenttypeid' => $contenttype['contenttypeid']
				)
			);
		}
	}

	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'contenttype', 1, 2));

		$assertor = vB::getDbAssertor();

		// This package was added/verified in 518a3
		$package = $assertor->getRow('package', array('class' => 'vBCms'));
		$contenttypes = $assertor->getRows(
			'vBForum:contenttype',
			array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'class',		'value' => 'Article',				'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'packageid',	'value' => $package['packageid'],	'operator' =>  vB_dB_Query::OPERATOR_EQ),
					array('field' => 'cansearch',	'value' => 1, 						'operator' =>  vB_dB_Query::OPERATOR_EQ),
				)
			)
		);
		foreach ($contenttypes AS $contenttype)
		{
			$assertor->update('vBForum:contenttype',
				array(// update values
					'cansearch' => 0,
				),
				array(// update conditions
					'contenttypeid' => $contenttype['contenttypeid']
				)
			);
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112179 $
|| ####################################################################
\*======================================================================*/